/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The database edition capabilities.
 */
public class EditionCapability {
    /**
     * The edition name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The status of the edition. Possible values include: 'Visible',
     * 'Available', 'Default', 'Disabled'.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;

    /**
     * The list of supported service objectives for the edition.
     */
    @JsonProperty(value = "supportedServiceLevelObjectives", access = JsonProperty.Access.WRITE_ONLY)
    private List<ServiceObjectiveCapability> supportedServiceLevelObjectives;

    /**
     * Whether or not zone redundancy is supported for the edition.
     */
    @JsonProperty(value = "zoneRedundant", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean zoneRedundant;

    /**
     * Get the edition name.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status of the edition. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'.
     *
     * @return the status value
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the list of supported service objectives for the edition.
     *
     * @return the supportedServiceLevelObjectives value
     */
    public List<ServiceObjectiveCapability> supportedServiceLevelObjectives() {
        return this.supportedServiceLevelObjectives;
    }

    /**
     * Get whether or not zone redundancy is supported for the edition.
     *
     * @return the zoneRedundant value
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

}
