/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.CompleteDatabaseRestoreDefinition;
import com.microsoft.azure.management.sql.ManagedDatabaseUpdate;
import com.microsoft.azure.management.sql.implementation.ManagedDatabaseInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedDatabasesInner {
    private ManagedDatabasesService service;
    private SqlManagementClientImpl client;

    public ManagedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedDatabasesService)retrofit.create(ManagedDatabasesService.class);
        this.client = client;
    }

    public void completeRestore(String locationName, UUID operationId, String lastBackupName) {
        ((ServiceResponse)this.completeRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> completeRestoreAsync(String locationName, UUID operationId, String lastBackupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.completeRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName), serviceCallback);
    }

    public Observable<Void> completeRestoreAsync(String locationName, UUID operationId, String lastBackupName) {
        return this.completeRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> completeRestoreWithServiceResponseAsync(String locationName, UUID operationId, String lastBackupName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (lastBackupName == null) {
            throw new IllegalArgumentException("Parameter lastBackupName is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        CompleteDatabaseRestoreDefinition parameters = new CompleteDatabaseRestoreDefinition();
        parameters.withLastBackupName(lastBackupName);
        Observable<Response<ResponseBody>> observable = this.service.completeRestore(locationName, operationId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginCompleteRestore(String locationName, UUID operationId, String lastBackupName) {
        ((ServiceResponse)this.beginCompleteRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginCompleteRestoreAsync(String locationName, UUID operationId, String lastBackupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCompleteRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName), serviceCallback);
    }

    public Observable<Void> beginCompleteRestoreAsync(String locationName, UUID operationId, String lastBackupName) {
        return this.beginCompleteRestoreWithServiceResponseAsync(locationName, operationId, lastBackupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginCompleteRestoreWithServiceResponseAsync(String locationName, UUID operationId, String lastBackupName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (lastBackupName == null) {
            throw new IllegalArgumentException("Parameter lastBackupName is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        CompleteDatabaseRestoreDefinition parameters = new CompleteDatabaseRestoreDefinition();
        parameters.withLastBackupName(lastBackupName);
        return this.service.beginCompleteRestore(locationName, operationId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabasesInner.this.beginCompleteRestoreDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCompleteRestoreDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedDatabaseInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedDatabaseInner>((Page)response.body()){

            public Page<ManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<ManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(String nextPageLink) {
                return ManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedDatabaseInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseInner>>, Page<ManagedDatabaseInner>>(){

            public Page<ManagedDatabaseInner> call(ServiceResponse<Page<ManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseInner>>, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(ServiceResponse<Page<ManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabasesInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedDatabaseInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedDatabaseInner get(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedDatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedDatabaseInner>, ManagedDatabaseInner>(){

            public ManagedDatabaseInner call(ServiceResponse<ManagedDatabaseInner> response) {
                return (ManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedDatabaseInner>>>(){

            public Observable<ServiceResponse<ManagedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedDatabaseInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        return (ManagedDatabaseInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedDatabaseInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters, ServiceCallback<ManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<ManagedDatabaseInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ManagedDatabaseInner>, ManagedDatabaseInner>(){

            public ManagedDatabaseInner call(ServiceResponse<ManagedDatabaseInner> response) {
                return (ManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedDatabaseInner>(){}.getType());
    }

    public ManagedDatabaseInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        return (ManagedDatabaseInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedDatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters, ServiceCallback<ManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<ManagedDatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ManagedDatabaseInner>, ManagedDatabaseInner>(){

            public ManagedDatabaseInner call(ServiceResponse<ManagedDatabaseInner> response) {
                return (ManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedDatabaseInner>>>(){

            public Observable<ServiceResponse<ManagedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabasesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedDatabaseInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedDatabaseInner>(){}.getType()).register(201, new TypeToken<ManagedDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName, String databaseName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String managedInstanceName, String databaseName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginDelete(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabasesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedDatabaseInner update(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        return (ManagedDatabaseInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedDatabaseInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters, ServiceCallback<ManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<ManagedDatabaseInner> updateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ManagedDatabaseInner>, ManagedDatabaseInner>(){

            public ManagedDatabaseInner call(ServiceResponse<ManagedDatabaseInner> response) {
                return (ManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedDatabaseInner>(){}.getType());
    }

    public ManagedDatabaseInner beginUpdate(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        return (ManagedDatabaseInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedDatabaseInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters, ServiceCallback<ManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<ManagedDatabaseInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ManagedDatabaseInner>, ManagedDatabaseInner>(){

            public ManagedDatabaseInner call(ServiceResponse<ManagedDatabaseInner> response) {
                return (ManagedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-03-01-preview";
        return this.service.beginUpdate(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedDatabaseInner>>>(){

            public Observable<ServiceResponse<ManagedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabasesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedDatabaseInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedDatabaseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedDatabaseInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedDatabaseInner>((Page)response.body()){

            public Page<ManagedDatabaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<ManagedDatabaseInner>> serviceFuture, ListOperationCallback<ManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(String nextPageLink) {
                return ManagedDatabasesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedDatabaseInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseInner>>, Page<ManagedDatabaseInner>>(){

            public Page<ManagedDatabaseInner> call(ServiceResponse<Page<ManagedDatabaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseInner>>, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(ServiceResponse<Page<ManagedDatabaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabasesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedDatabaseInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabasesInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedDatabaseInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedDatabasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases completeRestore"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/managedDatabaseRestoreAzureAsyncOperation/{operationId}/completeRestore")
        public Observable<Response<ResponseBody>> completeRestore(@Path(value="locationName") String var1, @Path(value="operationId") UUID var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CompleteDatabaseRestoreDefinition var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases beginCompleteRestore"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/managedDatabaseRestoreAzureAsyncOperation/{operationId}/completeRestore")
        public Observable<Response<ResponseBody>> beginCompleteRestore(@Path(value="locationName") String var1, @Path(value="operationId") UUID var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CompleteDatabaseRestoreDefinition var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedDatabaseInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedDatabaseInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedDatabaseUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedDatabaseUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabases listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

