/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.DatabaseVulnerabilityAssessmentInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedDatabaseVulnerabilityAssessmentsInner {
    private ManagedDatabaseVulnerabilityAssessmentsService service;
    private SqlManagementClientImpl client;

    public ManagedDatabaseVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseVulnerabilityAssessmentsService)retrofit.create(ManagedDatabaseVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    public DatabaseVulnerabilityAssessmentInner get(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (DatabaseVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return (DatabaseVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).register(201, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName, String databaseName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.delete(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseVulnerabilityAssessmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabase(String resourceGroupName, String managedInstanceName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>(){

            public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByDatabase(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseVulnerabilityAssessmentInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DatabaseVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<DatabaseVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<DatabaseVulnerabilityAssessmentInner>> serviceFuture, ListOperationCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Page<DatabaseVulnerabilityAssessmentInner>>(){

            public Page<DatabaseVulnerabilityAssessmentInner> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<DatabaseVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabaseVulnerabilityAssessmentsInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<DatabaseVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedDatabaseVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Body DatabaseVulnerabilityAssessmentInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseVulnerabilityAssessments listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

