/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.sql.InstancePoolUpdate;
import com.microsoft.azure.management.sql.implementation.InstancePoolInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class InstancePoolsInner
implements InnerSupportsGet<InstancePoolInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<InstancePoolInner> {
    private InstancePoolsService service;
    private SqlManagementClientImpl client;

    public InstancePoolsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (InstancePoolsService)retrofit.create(InstancePoolsService.class);
        this.client = client;
    }

    public InstancePoolInner getByResourceGroup(String resourceGroupName, String instancePoolName) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single()).body());
    }

    public ServiceFuture<InstancePoolInner> getByResourceGroupAsync(String resourceGroupName, String instancePoolName, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    public Observable<InstancePoolInner> getByResourceGroupAsync(String resourceGroupName, String instancePoolName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.getByResourceGroup(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>(){

            public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstancePoolsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstancePoolInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstancePoolInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InstancePoolInner createOrUpdate(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<InstancePoolInner> createOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters), serviceCallback);
    }

    public Observable<InstancePoolInner> createOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-06-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), parameters, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>(){}.getType());
    }

    public InstancePoolInner beginCreateOrUpdate(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<InstancePoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters), serviceCallback);
    }

    public Observable<InstancePoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-06-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), parameters, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>(){

            public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstancePoolsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstancePoolInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstancePoolInner>(){}.getType()).register(201, new TypeToken<InstancePoolInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String instancePoolName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String instancePoolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String instancePoolName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String instancePoolName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String instancePoolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String instancePoolName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.beginDelete(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstancePoolsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InstancePoolInner update(String resourceGroupName, String instancePoolName) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().last()).body());
    }

    public ServiceFuture<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    public Observable<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> updateWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        Object tags = null;
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>(){}.getType());
    }

    public InstancePoolInner update(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags), serviceCallback);
    }

    public Observable<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> updateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01-preview";
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>(){}.getType());
    }

    public InstancePoolInner beginUpdate(String resourceGroupName, String instancePoolName) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single()).body());
    }

    public ServiceFuture<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    public Observable<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        Object tags = null;
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(null);
        return this.service.beginUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>(){

            public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstancePoolsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public InstancePoolInner beginUpdate(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return (InstancePoolInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags, ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags), serviceCallback);
    }

    public Observable<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).map((Func1)new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>(){

            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return (InstancePoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstancePoolInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01-preview";
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(tags);
        return this.service.beginUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>(){

            public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstancePoolsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstancePoolInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstancePoolInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstancePoolInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<InstancePoolInner>((Page)response.body()){

            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstancePoolsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstancePoolInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                return InstancePoolsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstancePoolInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>(){

            public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstancePoolsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstancePoolsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstancePoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstancePoolInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<InstancePoolInner>((Page)response.body()){

            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstancePoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstancePoolInner>> listAsync(ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                return InstancePoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstancePoolInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>(){

            public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstancePoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.list(this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstancePoolsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstancePoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstancePoolInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstancePoolInner>((Page)response.body()){

            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstancePoolsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstancePoolInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<InstancePoolInner>> serviceFuture, ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                return InstancePoolsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstancePoolInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>(){

            public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstancePoolsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstancePoolsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstancePoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstancePoolInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstancePoolInner>((Page)response.body()){

            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstancePoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstancePoolInner>> listNextAsync(String nextPageLink, ServiceFuture<List<InstancePoolInner>> serviceFuture, ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                return InstancePoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstancePoolInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>(){

            public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstancePoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstancePoolInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>(){

            public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstancePoolsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstancePoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface InstancePoolsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Body InstancePoolInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Body InstancePoolInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body InstancePoolUpdate var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body InstancePoolUpdate var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/instancePools")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

