/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.JobStepAction;
import com.microsoft.azure.management.sql.JobStepOutput;
import com.microsoft.azure.management.sql.JobStepExecutionOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A job step.
 */
@JsonFlatten
public class JobStepInner extends ProxyResource {
    /**
     * The job step's index within the job. If not specified when creating the
     * job step, it will be created as the last step. If not specified when
     * updating the job step, the step id is not modified.
     */
    @JsonProperty(value = "properties.stepId")
    private Integer stepId;

    /**
     * The resource ID of the target group that the job step will be executed
     * on.
     */
    @JsonProperty(value = "properties.targetGroup", required = true)
    private String targetGroup;

    /**
     * The resource ID of the job credential that will be used to connect to
     * the targets.
     */
    @JsonProperty(value = "properties.credential", required = true)
    private String credential;

    /**
     * The action payload of the job step.
     */
    @JsonProperty(value = "properties.action", required = true)
    private JobStepAction action;

    /**
     * Output destination properties of the job step.
     */
    @JsonProperty(value = "properties.output")
    private JobStepOutput output;

    /**
     * Execution options for the job step.
     */
    @JsonProperty(value = "properties.executionOptions")
    private JobStepExecutionOptions executionOptions;

    /**
     * Get the job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
     *
     * @return the stepId value
     */
    public Integer stepId() {
        return this.stepId;
    }

    /**
     * Set the job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
     *
     * @param stepId the stepId value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withStepId(Integer stepId) {
        this.stepId = stepId;
        return this;
    }

    /**
     * Get the resource ID of the target group that the job step will be executed on.
     *
     * @return the targetGroup value
     */
    public String targetGroup() {
        return this.targetGroup;
    }

    /**
     * Set the resource ID of the target group that the job step will be executed on.
     *
     * @param targetGroup the targetGroup value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
        return this;
    }

    /**
     * Get the resource ID of the job credential that will be used to connect to the targets.
     *
     * @return the credential value
     */
    public String credential() {
        return this.credential;
    }

    /**
     * Set the resource ID of the job credential that will be used to connect to the targets.
     *
     * @param credential the credential value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Get the action payload of the job step.
     *
     * @return the action value
     */
    public JobStepAction action() {
        return this.action;
    }

    /**
     * Set the action payload of the job step.
     *
     * @param action the action value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withAction(JobStepAction action) {
        this.action = action;
        return this;
    }

    /**
     * Get output destination properties of the job step.
     *
     * @return the output value
     */
    public JobStepOutput output() {
        return this.output;
    }

    /**
     * Set output destination properties of the job step.
     *
     * @param output the output value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withOutput(JobStepOutput output) {
        this.output = output;
        return this;
    }

    /**
     * Get execution options for the job step.
     *
     * @return the executionOptions value
     */
    public JobStepExecutionOptions executionOptions() {
        return this.executionOptions;
    }

    /**
     * Set execution options for the job step.
     *
     * @param executionOptions the executionOptions value to set
     * @return the JobStepInner object itself.
     */
    public JobStepInner withExecutionOptions(JobStepExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

}
