/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A database Vulnerability Assessment scan export resource.
 */
@JsonFlatten
public class DatabaseVulnerabilityAssessmentScansExportInner extends ProxyResource {
    /**
     * Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     */
    @JsonProperty(value = "properties.exportedReportLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String exportedReportLocation;

    /**
     * Get location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     *
     * @return the exportedReportLocation value
     */
    public String exportedReportLocation() {
        return this.exportedReportLocation;
    }

}
