/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Export database parameters.
 */
public class ExportRequest {
    /**
     * The type of the storage key to use. Possible values include:
     * 'StorageAccessKey', 'SharedAccessKey'.
     */
    @JsonProperty(value = "storageKeyType", required = true)
    private StorageKeyType storageKeyType;

    /**
     * The storage key to use.  If storage key type is SharedAccessKey, it must
     * be preceded with a "?.".
     */
    @JsonProperty(value = "storageKey", required = true)
    private String storageKey;

    /**
     * The storage uri to use.
     */
    @JsonProperty(value = "storageUri", required = true)
    private String storageUri;

    /**
     * The name of the SQL administrator.
     */
    @JsonProperty(value = "administratorLogin", required = true)
    private String administratorLogin;

    /**
     * The password of the SQL administrator.
     */
    @JsonProperty(value = "administratorLoginPassword", required = true)
    private String administratorLoginPassword;

    /**
     * The authentication type. Possible values include: 'SQL', 'ADPassword'.
     */
    @JsonProperty(value = "authenticationType")
    private AuthenticationType authenticationType;

    /**
     * Get the type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'.
     *
     * @return the storageKeyType value
     */
    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    /**
     * Set the type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'.
     *
     * @param storageKeyType the storageKeyType value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    /**
     * Get the storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?.".
     *
     * @return the storageKey value
     */
    public String storageKey() {
        return this.storageKey;
    }

    /**
     * Set the storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?.".
     *
     * @param storageKey the storageKey value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    /**
     * Get the storage uri to use.
     *
     * @return the storageUri value
     */
    public String storageUri() {
        return this.storageUri;
    }

    /**
     * Set the storage uri to use.
     *
     * @param storageUri the storageUri value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    /**
     * Get the name of the SQL administrator.
     *
     * @return the administratorLogin value
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the name of the SQL administrator.
     *
     * @param administratorLogin the administratorLogin value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the password of the SQL administrator.
     *
     * @return the administratorLoginPassword value
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the password of the SQL administrator.
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the authentication type. Possible values include: 'SQL', 'ADPassword'.
     *
     * @return the authenticationType value
     */
    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authentication type. Possible values include: 'SQL', 'ADPassword'.
     *
     * @param authenticationType the authenticationType value to set
     * @return the ExportRequest object itself.
     */
    public ExportRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

}
