/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlSyncFullSchemaProperty;
import com.microsoft.azure.management.sql.SqlSyncGroup;
import com.microsoft.azure.management.sql.SqlSyncGroupLogProperty;
import com.microsoft.azure.management.sql.SqlSyncGroupOperations;
import com.microsoft.azure.management.sql.SqlSyncMemberOperations;
import com.microsoft.azure.management.sql.SyncConflictResolutionPolicy;
import com.microsoft.azure.management.sql.SyncGroupSchema;
import com.microsoft.azure.management.sql.SyncGroupState;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupLogPropertyImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncMemberOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SyncFullSchemaPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncGroupInner;
import com.microsoft.azure.management.sql.implementation.SyncGroupLogPropertiesInner;
import java.util.Objects;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlSyncGroupImpl
extends ExternalChildResourceImpl<SqlSyncGroup, SyncGroupInner, SqlDatabaseImpl, SqlDatabase>
implements SqlSyncGroup,
SqlSyncGroup.Update,
SqlSyncGroupOperations.SqlSyncGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMemberOps;

    SqlSyncGroupImpl(String name, SqlDatabaseImpl parent, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.name();
    }

    SqlSyncGroupImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
    }

    SqlSyncGroupImpl(String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((SyncGroupInner)((Object)this.inner())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((SyncGroupInner)((Object)this.inner())).id());
    }

    @Override
    public int interval() {
        return ((SyncGroupInner)((Object)this.inner())).interval();
    }

    @Override
    public DateTime lastSyncTime() {
        return ((SyncGroupInner)((Object)this.inner())).lastSyncTime();
    }

    @Override
    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return ((SyncGroupInner)((Object)this.inner())).conflictResolutionPolicy();
    }

    @Override
    public String syncDatabaseId() {
        return ((SyncGroupInner)((Object)this.inner())).syncDatabaseId();
    }

    @Override
    public String databaseUserName() {
        return ((SyncGroupInner)((Object)this.inner())).hubDatabaseUserName();
    }

    @Override
    public SyncGroupState syncState() {
        return ((SyncGroupInner)((Object)this.inner())).syncState();
    }

    @Override
    public SyncGroupSchema schema() {
        return ((SyncGroupInner)((Object)this.inner())).schema();
    }

    @Override
    public void refreshHubSchema() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().refreshHubSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Completable refreshHubSchemaAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().refreshHubSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()).toCompletable();
    }

    @Override
    public PagedList<SqlSyncFullSchemaProperty> listHubSchemas() {
        PagedListConverter<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty> converter = new PagedListConverter<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty>(){

            public Observable<SqlSyncFullSchemaProperty> typeConvertAsync(SyncFullSchemaPropertiesInner inner) {
                return Observable.just((Object)new SqlSyncFullSchemaPropertyImpl(inner));
            }
        };
        return converter.convert(((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listHubSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()));
    }

    @Override
    public Observable<SqlSyncFullSchemaProperty> listHubSchemasAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listHubSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()).flatMap((Func1)new Func1<Page<SyncFullSchemaPropertiesInner>, Observable<SyncFullSchemaPropertiesInner>>(){

            public Observable<SyncFullSchemaPropertiesInner> call(Page<SyncFullSchemaPropertiesInner> syncFullSchemaPropertiesInnerPage) {
                return Observable.from((Iterable)syncFullSchemaPropertiesInnerPage.items());
            }
        }).map((Func1)new Func1<SyncFullSchemaPropertiesInner, SqlSyncFullSchemaProperty>(){

            public SqlSyncFullSchemaProperty call(SyncFullSchemaPropertiesInner syncFullSchemaPropertiesInner) {
                return new SqlSyncFullSchemaPropertyImpl(syncFullSchemaPropertiesInner);
            }
        });
    }

    @Override
    public PagedList<SqlSyncGroupLogProperty> listLogs(String startTime, String endTime, String type) {
        PagedListConverter<SyncGroupLogPropertiesInner, SqlSyncGroupLogProperty> converter = new PagedListConverter<SyncGroupLogPropertiesInner, SqlSyncGroupLogProperty>(){

            public Observable<SqlSyncGroupLogProperty> typeConvertAsync(SyncGroupLogPropertiesInner inner) {
                return Observable.just((Object)new SqlSyncGroupLogPropertyImpl(inner));
            }
        };
        return converter.convert(((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listLogs(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, type));
    }

    @Override
    public Observable<SqlSyncGroupLogProperty> listLogsAsync(String startTime, String endTime, String type) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listLogsAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, type).flatMap((Func1)new Func1<Page<SyncGroupLogPropertiesInner>, Observable<SyncGroupLogPropertiesInner>>(){

            public Observable<SyncGroupLogPropertiesInner> call(Page<SyncGroupLogPropertiesInner> syncGroupLogPropertiesInnerPage) {
                return Observable.from((Iterable)syncGroupLogPropertiesInnerPage.items());
            }
        }).map((Func1)new Func1<SyncGroupLogPropertiesInner, SqlSyncGroupLogProperty>(){

            public SqlSyncGroupLogProperty call(SyncGroupLogPropertiesInner syncGroupLogPropertiesInner) {
                return new SqlSyncGroupLogPropertyImpl(syncGroupLogPropertiesInner);
            }
        });
    }

    @Override
    public void triggerSynchronization() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().triggerSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Completable triggerSynchronizationAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().triggerSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()).toCompletable();
    }

    @Override
    public void cancelSynchronization() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().cancelSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Completable cancelSynchronizationAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().cancelSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()).toCompletable();
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlDatabase(SqlDatabase sqlDatabase) {
        this.resourceGroupName = sqlDatabase.resourceGroupName();
        this.sqlServerName = sqlDatabase.sqlServerName();
        this.sqlDatabaseName = sqlDatabase.name();
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSyncDatabaseId(String syncDatabaseId) {
        ((SyncGroupInner)((Object)this.inner())).withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabaseUserName(String userName) {
        ((SyncGroupInner)((Object)this.inner())).withHubDatabaseUserName(userName);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabasePassword(String password) {
        ((SyncGroupInner)((Object)this.inner())).withHubDatabasePassword(password);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyHubWins() {
        ((SyncGroupInner)((Object)this.inner())).withConflictResolutionPolicy(SyncConflictResolutionPolicy.HUB_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyMemberWins() {
        ((SyncGroupInner)((Object)this.inner())).withConflictResolutionPolicy(SyncConflictResolutionPolicy.MEMBER_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withInterval(int interval) {
        ((SyncGroupInner)((Object)this.inner())).withInterval(interval);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSchema(SyncGroupSchema schema) {
        ((SyncGroupInner)((Object)this.inner())).withSchema(schema);
        return this;
    }

    public SqlSyncGroup.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    public Observable<SqlSyncGroup> createResourceAsync() {
        final SqlSyncGroupImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), (SyncGroupInner)((Object)this.inner())).map((Func1)new Func1<SyncGroupInner, SqlSyncGroup>(){

            public SqlSyncGroup call(SyncGroupInner syncGroupInner) {
                self.setInner((Object)syncGroupInner);
                return self;
            }
        });
    }

    public Observable<SqlSyncGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    protected Observable<SyncGroupInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMembers() {
        if (this.syncMemberOps == null) {
            this.syncMemberOps = new SqlSyncMemberOperationsImpl(this, this.sqlServerManager);
        }
        return this.syncMemberOps;
    }
}

