/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.UsageInner;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class UsagesInner {
    private UsagesService service;
    private SqlManagementClientImpl client;

    public UsagesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (UsagesService)retrofit.create(UsagesService.class);
        this.client = client;
    }

    public PagedList<UsageInner> listByInstancePool(String resourceGroupName, String instancePoolName) {
        ServiceResponse response = (ServiceResponse)this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listByInstancePoolAsync(String resourceGroupName, String instancePoolName, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listByInstancePoolAsync(String resourceGroupName, String instancePoolName) {
        return this.listByInstancePoolWithServiceResponseAsync(resourceGroupName, instancePoolName).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        return this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsagesInner.this.listByInstancePoolNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolSinglePageAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        Boolean expandChildren = null;
        return this.service.listByInstancePool(resourceGroupName, instancePoolName, this.client.subscriptionId(), expandChildren, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsagesInner.this.listByInstancePoolDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<UsageInner> listByInstancePool(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        ServiceResponse response = (ServiceResponse)this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listByInstancePoolAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listByInstancePoolAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        return this.listByInstancePoolWithServiceResponseAsync(resourceGroupName, instancePoolName, expandChildren).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolWithServiceResponseAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        return this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsagesInner.this.listByInstancePoolNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolSinglePageAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.listByInstancePool(resourceGroupName, instancePoolName, this.client.subscriptionId(), expandChildren, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsagesInner.this.listByInstancePoolDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<UsageInner>> listByInstancePoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<UsageInner> listByInstancePoolNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstancePoolNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listByInstancePoolNextAsync(String nextPageLink, ServiceFuture<List<UsageInner>> serviceFuture, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstancePoolNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return UsagesInner.this.listByInstancePoolNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listByInstancePoolNextAsync(String nextPageLink) {
        return this.listByInstancePoolNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstancePoolNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsagesInner.this.listByInstancePoolNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listByInstancePoolNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstancePoolNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsagesInner.this.listByInstancePoolNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<UsageInner>> listByInstancePoolNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface UsagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Usages listByInstancePool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}/usages")
        public Observable<Response<ResponseBody>> listByInstancePool(@Path(value="resourceGroupName") String var1, @Path(value="instancePoolName") String var2, @Path(value="subscriptionId") String var3, @Query(value="expandChildren") Boolean var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Usages listByInstancePoolNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstancePoolNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

