/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SubscriptionUsageInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SubscriptionUsagesInner {
    private SubscriptionUsagesService service;
    private SqlManagementClientImpl client;

    public SubscriptionUsagesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (SubscriptionUsagesService)retrofit.create(SubscriptionUsagesService.class);
        this.client = client;
    }

    public PagedList<SubscriptionUsageInner> listByLocation(String locationName) {
        ServiceResponse response = (ServiceResponse)this.listByLocationSinglePageAsync(locationName).toBlocking().single();
        return new PagedList<SubscriptionUsageInner>((Page)response.body()){

            public Page<SubscriptionUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionUsagesInner.this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubscriptionUsageInner>> listByLocationAsync(String locationName, ListOperationCallback<SubscriptionUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByLocationSinglePageAsync(locationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(String nextPageLink) {
                return SubscriptionUsagesInner.this.listByLocationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionUsageInner>> listByLocationAsync(String locationName) {
        return this.listByLocationWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<Page<SubscriptionUsageInner>>, Page<SubscriptionUsageInner>>(){

            public Page<SubscriptionUsageInner> call(ServiceResponse<Page<SubscriptionUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> listByLocationWithServiceResponseAsync(String locationName) {
        return this.listByLocationSinglePageAsync(locationName).concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionUsageInner>>, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(ServiceResponse<Page<SubscriptionUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionUsagesInner.this.listByLocationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> listByLocationSinglePageAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByLocation(locationName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionUsagesInner.this.listByLocationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SubscriptionUsageInner>> listByLocationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SubscriptionUsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubscriptionUsageInner get(String locationName, String usageName) {
        return (SubscriptionUsageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(locationName, usageName).toBlocking().single()).body());
    }

    public ServiceFuture<SubscriptionUsageInner> getAsync(String locationName, String usageName, ServiceCallback<SubscriptionUsageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(locationName, usageName), serviceCallback);
    }

    public Observable<SubscriptionUsageInner> getAsync(String locationName, String usageName) {
        return this.getWithServiceResponseAsync(locationName, usageName).map((Func1)new Func1<ServiceResponse<SubscriptionUsageInner>, SubscriptionUsageInner>(){

            public SubscriptionUsageInner call(ServiceResponse<SubscriptionUsageInner> response) {
                return (SubscriptionUsageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubscriptionUsageInner>> getWithServiceResponseAsync(String locationName, String usageName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (usageName == null) {
            throw new IllegalArgumentException("Parameter usageName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(locationName, usageName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionUsageInner>>>(){

            public Observable<ServiceResponse<SubscriptionUsageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionUsagesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubscriptionUsageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SubscriptionUsageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubscriptionUsageInner> listByLocationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SubscriptionUsageInner>((Page)response.body()){

            public Page<SubscriptionUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionUsagesInner.this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubscriptionUsageInner>> listByLocationNextAsync(String nextPageLink, ServiceFuture<List<SubscriptionUsageInner>> serviceFuture, ListOperationCallback<SubscriptionUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByLocationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(String nextPageLink) {
                return SubscriptionUsagesInner.this.listByLocationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionUsageInner>> listByLocationNextAsync(String nextPageLink) {
        return this.listByLocationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SubscriptionUsageInner>>, Page<SubscriptionUsageInner>>(){

            public Page<SubscriptionUsageInner> call(ServiceResponse<Page<SubscriptionUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> listByLocationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByLocationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionUsageInner>>, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(ServiceResponse<Page<SubscriptionUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionUsagesInner.this.listByLocationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> listByLocationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByLocationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionUsageInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionUsagesInner.this.listByLocationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SubscriptionUsageInner>> listByLocationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SubscriptionUsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SubscriptionUsagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SubscriptionUsages listByLocation"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/usages")
        public Observable<Response<ResponseBody>> listByLocation(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SubscriptionUsages get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/usages/{usageName}")
        public Observable<Response<ResponseBody>> get(@Path(value="locationName") String var1, @Path(value="usageName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SubscriptionUsages listByLocationNext"})
        @GET
        public Observable<Response<ResponseBody>> listByLocationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

