/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SecurityAlertPolicyState;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerSecurityAlertPolicy;
import com.microsoft.azure.management.sql.SqlServerSecurityAlertPolicyOperations;
import com.microsoft.azure.management.sql.implementation.ServerSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerSecurityAlertPolicyImpl
extends ExternalChildResourceImpl<SqlServerSecurityAlertPolicy, ServerSecurityAlertPolicyInner, SqlServerImpl, SqlServer>
implements SqlServerSecurityAlertPolicy,
SqlServerSecurityAlertPolicy.Update,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerSecurityAlertPolicyImpl(SqlServerImpl parent, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlServerSecurityAlertPolicyImpl(String resourceGroupName, String sqlServerName, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlServerSecurityAlertPolicyImpl(ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String id() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).id();
    }

    public String name() {
        return "Default";
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((ServerSecurityAlertPolicyInner)((Object)this.inner())).id());
    }

    @Override
    public SecurityAlertPolicyState state() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).state();
    }

    @Override
    public List<String> disabledAlerts() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)((Object)this.inner())).disabledAlerts());
    }

    @Override
    public List<String> emailAddresses() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)((Object)this.inner())).emailAddresses());
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).emailAccountAdmins();
    }

    @Override
    public String storageEndpoint() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.inner())).retentionDays();
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    public SqlServerSecurityAlertPolicyImpl update() {
        super.prepareUpdate();
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withStorageEndpoint(null);
        return this;
    }

    public Observable<SqlServerSecurityAlertPolicy> createResourceAsync() {
        final SqlServerSecurityAlertPolicyImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverSecurityAlertPolicies().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, (ServerSecurityAlertPolicyInner)((Object)self.inner())).map((Func1)new Func1<ServerSecurityAlertPolicyInner, SqlServerSecurityAlertPolicy>(){

            public SqlServerSecurityAlertPolicy call(ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner) {
                self.setInner((Object)serverSecurityAlertPolicyInner);
                return self;
            }
        });
    }

    public Observable<SqlServerSecurityAlertPolicy> updateResourceAsync() {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withStorageEndpoint(null);
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return null;
    }

    protected Observable<ServerSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serverSecurityAlertPolicies().getAsync(this.resourceGroupName, this.sqlServerName);
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withState(SecurityAlertPolicyState state) {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withState(state);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withEmailAccountAdmins(true);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withoutEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withEmailAccountAdmins(false);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withStorageEndpoint(String storageEndpointUri, String storageAccessKey) {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withStorageEndpoint(storageEndpointUri);
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withStorageAccountAccessKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAddresses(String ... emailAddresses) {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withEmailAddresses(Arrays.asList(emailAddresses));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withDisabledAlerts(String ... disabledAlerts) {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withDisabledAlerts(Arrays.asList(disabledAlerts));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withRetentionDays(int days) {
        ((ServerSecurityAlertPolicyInner)((Object)this.inner())).withRetentionDays(days);
        return this;
    }
}

