/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.ServerCommunicationLinkInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServerCommunicationLinksInner {
    private ServerCommunicationLinksService service;
    private SqlManagementClientImpl client;

    public ServerCommunicationLinksInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerCommunicationLinksService)retrofit.create(ServerCommunicationLinksService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String serverName, String communicationLinkName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String communicationLinkName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String communicationLinkName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String communicationLinkName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (communicationLinkName == null) {
            throw new IllegalArgumentException("Parameter communicationLinkName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, serverName, communicationLinkName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerCommunicationLinksInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerCommunicationLinkInner get(String resourceGroupName, String serverName, String communicationLinkName) {
        return (ServerCommunicationLinkInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerCommunicationLinkInner> getAsync(String resourceGroupName, String serverName, String communicationLinkName, ServiceCallback<ServerCommunicationLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName), serviceCallback);
    }

    public Observable<ServerCommunicationLinkInner> getAsync(String resourceGroupName, String serverName, String communicationLinkName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName).map((Func1)new Func1<ServiceResponse<ServerCommunicationLinkInner>, ServerCommunicationLinkInner>(){

            public ServerCommunicationLinkInner call(ServiceResponse<ServerCommunicationLinkInner> response) {
                return (ServerCommunicationLinkInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerCommunicationLinkInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String communicationLinkName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (communicationLinkName == null) {
            throw new IllegalArgumentException("Parameter communicationLinkName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, communicationLinkName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerCommunicationLinkInner>>>(){

            public Observable<ServiceResponse<ServerCommunicationLinkInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerCommunicationLinksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerCommunicationLinkInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerCommunicationLinkInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerCommunicationLinkInner createOrUpdate(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        return (ServerCommunicationLinkInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer).toBlocking().last()).body());
    }

    public ServiceFuture<ServerCommunicationLinkInner> createOrUpdateAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer, ServiceCallback<ServerCommunicationLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer), serviceCallback);
    }

    public Observable<ServerCommunicationLinkInner> createOrUpdateAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer).map((Func1)new Func1<ServiceResponse<ServerCommunicationLinkInner>, ServerCommunicationLinkInner>(){

            public ServerCommunicationLinkInner call(ServiceResponse<ServerCommunicationLinkInner> response) {
                return (ServerCommunicationLinkInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerCommunicationLinkInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (communicationLinkName == null) {
            throw new IllegalArgumentException("Parameter communicationLinkName is required and cannot be null.");
        }
        if (partnerServer == null) {
            throw new IllegalArgumentException("Parameter partnerServer is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        ServerCommunicationLinkInner parameters = new ServerCommunicationLinkInner();
        parameters.withPartnerServer(partnerServer);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, communicationLinkName, "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerCommunicationLinkInner>(){}.getType());
    }

    public ServerCommunicationLinkInner beginCreateOrUpdate(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        return (ServerCommunicationLinkInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer).toBlocking().single()).body());
    }

    public ServiceFuture<ServerCommunicationLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer, ServiceCallback<ServerCommunicationLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer), serviceCallback);
    }

    public Observable<ServerCommunicationLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, communicationLinkName, partnerServer).map((Func1)new Func1<ServiceResponse<ServerCommunicationLinkInner>, ServerCommunicationLinkInner>(){

            public ServerCommunicationLinkInner call(ServiceResponse<ServerCommunicationLinkInner> response) {
                return (ServerCommunicationLinkInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerCommunicationLinkInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String communicationLinkName, String partnerServer) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (communicationLinkName == null) {
            throw new IllegalArgumentException("Parameter communicationLinkName is required and cannot be null.");
        }
        if (partnerServer == null) {
            throw new IllegalArgumentException("Parameter partnerServer is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        ServerCommunicationLinkInner parameters = new ServerCommunicationLinkInner();
        parameters.withPartnerServer(partnerServer);
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, communicationLinkName, "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerCommunicationLinkInner>>>(){

            public Observable<ServiceResponse<ServerCommunicationLinkInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerCommunicationLinksInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerCommunicationLinkInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ServerCommunicationLinkInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ServerCommunicationLinkInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ServerCommunicationLinkInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<ServerCommunicationLinkInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<ServerCommunicationLinkInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<ServerCommunicationLinkInner>>, List<ServerCommunicationLinkInner>>(){

            public List<ServerCommunicationLinkInner> call(ServiceResponse<List<ServerCommunicationLinkInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ServerCommunicationLinkInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ServerCommunicationLinkInner>>>>(){

            public Observable<ServiceResponse<List<ServerCommunicationLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerCommunicationLinksInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServerCommunicationLinkInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServerCommunicationLinkInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerCommunicationLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerCommunicationLinks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="communicationLinkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerCommunicationLinks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="communicationLinkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerCommunicationLinks createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="communicationLinkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ServerCommunicationLinkInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerCommunicationLinks beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="communicationLinkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ServerCommunicationLinkInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerCommunicationLinks listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

