/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.RestorableDroppedDatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class RestorableDroppedDatabasesInner {
    private RestorableDroppedDatabasesService service;
    private SqlManagementClientImpl client;

    public RestorableDroppedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (RestorableDroppedDatabasesService)retrofit.create(RestorableDroppedDatabasesService.class);
        this.client = client;
    }

    public RestorableDroppedDatabaseInner get(String resourceGroupName, String serverName, String restorableDroppededDatabaseId) {
        return (RestorableDroppedDatabaseInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, restorableDroppededDatabaseId).toBlocking().single()).body());
    }

    public ServiceFuture<RestorableDroppedDatabaseInner> getAsync(String resourceGroupName, String serverName, String restorableDroppededDatabaseId, ServiceCallback<RestorableDroppedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, restorableDroppededDatabaseId), serviceCallback);
    }

    public Observable<RestorableDroppedDatabaseInner> getAsync(String resourceGroupName, String serverName, String restorableDroppededDatabaseId) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, restorableDroppededDatabaseId).map((Func1)new Func1<ServiceResponse<RestorableDroppedDatabaseInner>, RestorableDroppedDatabaseInner>(){

            public RestorableDroppedDatabaseInner call(ServiceResponse<RestorableDroppedDatabaseInner> response) {
                return (RestorableDroppedDatabaseInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RestorableDroppedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String restorableDroppededDatabaseId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (restorableDroppededDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppededDatabaseId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, restorableDroppededDatabaseId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestorableDroppedDatabaseInner>>>(){

            public Observable<ServiceResponse<RestorableDroppedDatabaseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RestorableDroppedDatabasesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RestorableDroppedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RestorableDroppedDatabaseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<RestorableDroppedDatabaseInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<RestorableDroppedDatabaseInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<RestorableDroppedDatabaseInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<RestorableDroppedDatabaseInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<RestorableDroppedDatabaseInner>>, List<RestorableDroppedDatabaseInner>>(){

            public List<RestorableDroppedDatabaseInner> call(ServiceResponse<List<RestorableDroppedDatabaseInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RestorableDroppedDatabaseInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RestorableDroppedDatabaseInner>>>>(){

            public Observable<ServiceResponse<List<RestorableDroppedDatabaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RestorableDroppedDatabasesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RestorableDroppedDatabaseInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RestorableDroppedDatabaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RestorableDroppedDatabasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedDatabases get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/restorableDroppedDatabases/{restorableDroppededDatabaseId}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="restorableDroppededDatabaseId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedDatabases listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/restorableDroppedDatabases")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

