/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.sql.implementation.ManagedInstanceVulnerabilityAssessmentInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedInstanceVulnerabilityAssessmentsInner
implements InnerSupportsDelete<Void> {
    private ManagedInstanceVulnerabilityAssessmentsService service;
    private SqlManagementClientImpl client;

    public ManagedInstanceVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedInstanceVulnerabilityAssessmentsService)retrofit.create(ManagedInstanceVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    public ManagedInstanceVulnerabilityAssessmentInner get(String resourceGroupName, String managedInstanceName) {
        return (ManagedInstanceVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<ManagedInstanceVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>, ManagedInstanceVulnerabilityAssessmentInner>(){

            public ManagedInstanceVulnerabilityAssessmentInner call(ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> response) {
                return (ManagedInstanceVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, "default", this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceVulnerabilityAssessmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        return (ManagedInstanceVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters, ServiceCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>, ManagedInstanceVulnerabilityAssessmentInner>(){

            public ManagedInstanceVulnerabilityAssessmentInner call(ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> response) {
                return (ManagedInstanceVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.createOrUpdate(resourceGroupName, managedInstanceName, "default", this.client.subscriptionId(), parameters, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceVulnerabilityAssessmentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>(){}.getType()).register(201, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.delete(resourceGroupName, managedInstanceName, "default", this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceVulnerabilityAssessmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceVulnerabilityAssessmentInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedInstanceVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<ManagedInstanceVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Page<ManagedInstanceVulnerabilityAssessmentInner>>(){

            public Page<ManagedInstanceVulnerabilityAssessmentInner> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceVulnerabilityAssessmentInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<ManagedInstanceVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> serviceFuture, ListOperationCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Page<ManagedInstanceVulnerabilityAssessmentInner>>(){

            public Page<ManagedInstanceVulnerabilityAssessmentInner> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceVulnerabilityAssessmentsInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedInstanceVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedInstanceVulnerabilityAssessmentInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

