/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.InstanceFailoverGroupInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class InstanceFailoverGroupsInner {
    private InstanceFailoverGroupsService service;
    private SqlManagementClientImpl client;

    public InstanceFailoverGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (InstanceFailoverGroupsService)retrofit.create(InstanceFailoverGroupsService.class);
        this.client = client;
    }

    public InstanceFailoverGroupInner get(String resourceGroupName, String locationName, String failoverGroupName) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> getAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> getAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>(){

            public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstanceFailoverGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstanceFailoverGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstanceFailoverGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InstanceFailoverGroupInner createOrUpdate(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>(){}.getType());
    }

    public InstanceFailoverGroupInner beginCreateOrUpdate(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>(){

            public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstanceFailoverGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstanceFailoverGroupInner>(){}.getType()).register(201, new TypeToken<InstanceFailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String locationName, String failoverGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String locationName, String failoverGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.beginDelete(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstanceFailoverGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstanceFailoverGroupInner> listByLocation(String resourceGroupName, String locationName) {
        ServiceResponse response = (ServiceResponse)this.listByLocationSinglePageAsync(resourceGroupName, locationName).toBlocking().single();
        return new PagedList<InstanceFailoverGroupInner>((Page)response.body()){

            public Page<InstanceFailoverGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstanceFailoverGroupsInner.this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstanceFailoverGroupInner>> listByLocationAsync(String resourceGroupName, String locationName, ListOperationCallback<InstanceFailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByLocationSinglePageAsync(resourceGroupName, locationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(String nextPageLink) {
                return InstanceFailoverGroupsInner.this.listByLocationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstanceFailoverGroupInner>> listByLocationAsync(String resourceGroupName, String locationName) {
        return this.listByLocationWithServiceResponseAsync(resourceGroupName, locationName).map((Func1)new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Page<InstanceFailoverGroupInner>>(){

            public Page<InstanceFailoverGroupInner> call(ServiceResponse<Page<InstanceFailoverGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationWithServiceResponseAsync(String resourceGroupName, String locationName) {
        return this.listByLocationSinglePageAsync(resourceGroupName, locationName).concatMap((Func1)new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(ServiceResponse<Page<InstanceFailoverGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstanceFailoverGroupsInner.this.listByLocationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationSinglePageAsync(String resourceGroupName, String locationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByLocation(resourceGroupName, locationName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstanceFailoverGroupsInner.this.listByLocationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> listByLocationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstanceFailoverGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InstanceFailoverGroupInner failover(String resourceGroupName, String locationName, String failoverGroupName) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> failoverAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> failoverAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> failoverWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.failover(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>(){}.getType());
    }

    public InstanceFailoverGroupInner beginFailover(String resourceGroupName, String locationName, String failoverGroupName) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> beginFailoverAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> beginFailoverAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.beginFailover(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>(){

            public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstanceFailoverGroupsInner.this.beginFailoverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstanceFailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public InstanceFailoverGroupInner forceFailoverAllowDataLoss(String resourceGroupName, String locationName, String failoverGroupName) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> forceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.forceFailoverAllowDataLoss(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>(){}.getType());
    }

    public InstanceFailoverGroupInner beginForceFailoverAllowDataLoss(String resourceGroupName, String locationName, String failoverGroupName) {
        return (InstanceFailoverGroupInner)((Object)((ServiceResponse)this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName, ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    public Observable<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return this.beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map((Func1)new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>(){

            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return (InstanceFailoverGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginForceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.beginForceFailoverAllowDataLoss(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>(){

            public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = InstanceFailoverGroupsInner.this.beginForceFailoverAllowDataLossDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InstanceFailoverGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<InstanceFailoverGroupInner> listByLocationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstanceFailoverGroupInner>((Page)response.body()){

            public Page<InstanceFailoverGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)InstanceFailoverGroupsInner.this.listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<InstanceFailoverGroupInner>> listByLocationNextAsync(String nextPageLink, ServiceFuture<List<InstanceFailoverGroupInner>> serviceFuture, ListOperationCallback<InstanceFailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByLocationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(String nextPageLink) {
                return InstanceFailoverGroupsInner.this.listByLocationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<InstanceFailoverGroupInner>> listByLocationNextAsync(String nextPageLink) {
        return this.listByLocationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Page<InstanceFailoverGroupInner>>(){

            public Page<InstanceFailoverGroupInner> call(ServiceResponse<Page<InstanceFailoverGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByLocationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(ServiceResponse<Page<InstanceFailoverGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(InstanceFailoverGroupsInner.this.listByLocationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByLocationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>(){

            public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = InstanceFailoverGroupsInner.this.listByLocationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> listByLocationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<InstanceFailoverGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface InstanceFailoverGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body InstanceFailoverGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Body InstanceFailoverGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups listByLocation"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups")
        public Observable<Response<ResponseBody>> listByLocation(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups failover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/failover")
        public Observable<Response<ResponseBody>> failover(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginFailover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/failover")
        public Observable<Response<ResponseBody>> beginFailover(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups forceFailoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> forceFailoverAllowDataLoss(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginForceFailoverAllowDataLoss"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        public Observable<Response<ResponseBody>> beginForceFailoverAllowDataLoss(@Path(value="resourceGroupName") String var1, @Path(value="locationName") String var2, @Path(value="failoverGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups listByLocationNext"})
        @GET
        public Observable<Response<ResponseBody>> listByLocationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

