/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.BackupLongTermRetentionVaultInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class BackupLongTermRetentionVaultsInner {
    private BackupLongTermRetentionVaultsService service;
    private SqlManagementClientImpl client;

    public BackupLongTermRetentionVaultsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (BackupLongTermRetentionVaultsService)retrofit.create(BackupLongTermRetentionVaultsService.class);
        this.client = client;
    }

    public BackupLongTermRetentionVaultInner get(String resourceGroupName, String serverName) {
        return (BackupLongTermRetentionVaultInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<BackupLongTermRetentionVaultInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<BackupLongTermRetentionVaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<BackupLongTermRetentionVaultInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<BackupLongTermRetentionVaultInner>, BackupLongTermRetentionVaultInner>(){

            public BackupLongTermRetentionVaultInner call(ServiceResponse<BackupLongTermRetentionVaultInner> response) {
                return (BackupLongTermRetentionVaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BackupLongTermRetentionVaultInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String backupLongTermRetentionVaultName = "RegisteredVault";
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, "RegisteredVault", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupLongTermRetentionVaultInner>>>(){

            public Observable<ServiceResponse<BackupLongTermRetentionVaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupLongTermRetentionVaultsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupLongTermRetentionVaultInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackupLongTermRetentionVaultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BackupLongTermRetentionVaultInner createOrUpdate(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        return (BackupLongTermRetentionVaultInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId).toBlocking().last()).body());
    }

    public ServiceFuture<BackupLongTermRetentionVaultInner> createOrUpdateAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId, ServiceCallback<BackupLongTermRetentionVaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId), serviceCallback);
    }

    public Observable<BackupLongTermRetentionVaultInner> createOrUpdateAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId).map((Func1)new Func1<ServiceResponse<BackupLongTermRetentionVaultInner>, BackupLongTermRetentionVaultInner>(){

            public BackupLongTermRetentionVaultInner call(ServiceResponse<BackupLongTermRetentionVaultInner> response) {
                return (BackupLongTermRetentionVaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BackupLongTermRetentionVaultInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (recoveryServicesVaultResourceId == null) {
            throw new IllegalArgumentException("Parameter recoveryServicesVaultResourceId is required and cannot be null.");
        }
        String backupLongTermRetentionVaultName = "RegisteredVault";
        String apiVersion = "2014-04-01";
        BackupLongTermRetentionVaultInner parameters = new BackupLongTermRetentionVaultInner();
        parameters.withRecoveryServicesVaultResourceId(recoveryServicesVaultResourceId);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, "RegisteredVault", "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BackupLongTermRetentionVaultInner>(){}.getType());
    }

    public BackupLongTermRetentionVaultInner beginCreateOrUpdate(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        return (BackupLongTermRetentionVaultInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId).toBlocking().single()).body());
    }

    public ServiceFuture<BackupLongTermRetentionVaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId, ServiceCallback<BackupLongTermRetentionVaultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId), serviceCallback);
    }

    public Observable<BackupLongTermRetentionVaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, recoveryServicesVaultResourceId).map((Func1)new Func1<ServiceResponse<BackupLongTermRetentionVaultInner>, BackupLongTermRetentionVaultInner>(){

            public BackupLongTermRetentionVaultInner call(ServiceResponse<BackupLongTermRetentionVaultInner> response) {
                return (BackupLongTermRetentionVaultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BackupLongTermRetentionVaultInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String recoveryServicesVaultResourceId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (recoveryServicesVaultResourceId == null) {
            throw new IllegalArgumentException("Parameter recoveryServicesVaultResourceId is required and cannot be null.");
        }
        String backupLongTermRetentionVaultName = "RegisteredVault";
        String apiVersion = "2014-04-01";
        BackupLongTermRetentionVaultInner parameters = new BackupLongTermRetentionVaultInner();
        parameters.withRecoveryServicesVaultResourceId(recoveryServicesVaultResourceId);
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, "RegisteredVault", "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupLongTermRetentionVaultInner>>>(){

            public Observable<ServiceResponse<BackupLongTermRetentionVaultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupLongTermRetentionVaultsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupLongTermRetentionVaultInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackupLongTermRetentionVaultInner>(){}.getType()).register(201, new TypeToken<BackupLongTermRetentionVaultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<BackupLongTermRetentionVaultInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<BackupLongTermRetentionVaultInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<BackupLongTermRetentionVaultInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<BackupLongTermRetentionVaultInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<BackupLongTermRetentionVaultInner>>, List<BackupLongTermRetentionVaultInner>>(){

            public List<BackupLongTermRetentionVaultInner> call(ServiceResponse<List<BackupLongTermRetentionVaultInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<BackupLongTermRetentionVaultInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<BackupLongTermRetentionVaultInner>>>>(){

            public Observable<ServiceResponse<List<BackupLongTermRetentionVaultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BackupLongTermRetentionVaultsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BackupLongTermRetentionVaultInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BackupLongTermRetentionVaultInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BackupLongTermRetentionVaultsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupLongTermRetentionVaults get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults/{backupLongTermRetentionVaultName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="backupLongTermRetentionVaultName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupLongTermRetentionVaults createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults/{backupLongTermRetentionVaultName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="backupLongTermRetentionVaultName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BackupLongTermRetentionVaultInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupLongTermRetentionVaults beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults/{backupLongTermRetentionVaultName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="backupLongTermRetentionVaultName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BackupLongTermRetentionVaultInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupLongTermRetentionVaults listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

