/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ManagedDatabaseSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedDatabaseSecurityAlertPoliciesInner {
    private ManagedDatabaseSecurityAlertPoliciesService service;
    private SqlManagementClientImpl client;

    public ManagedDatabaseSecurityAlertPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseSecurityAlertPoliciesService)retrofit.create(ManagedDatabaseSecurityAlertPoliciesService.class);
        this.client = client;
    }

    public ManagedDatabaseSecurityAlertPolicyInner get(String resourceGroupName, String managedInstanceName, String databaseName) {
        return (ManagedDatabaseSecurityAlertPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedDatabaseSecurityAlertPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, ServiceCallback<ManagedDatabaseSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName), serviceCallback);
    }

    public Observable<ManagedDatabaseSecurityAlertPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>, ManagedDatabaseSecurityAlertPolicyInner>(){

            public ManagedDatabaseSecurityAlertPolicyInner call(ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner> response) {
                return (ManagedDatabaseSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String securityAlertPolicyName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseSecurityAlertPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedDatabaseSecurityAlertPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedDatabaseSecurityAlertPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseSecurityAlertPolicyInner parameters) {
        return (ManagedDatabaseSecurityAlertPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedDatabaseSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseSecurityAlertPolicyInner parameters, ServiceCallback<ManagedDatabaseSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters), serviceCallback);
    }

    public Observable<ManagedDatabaseSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseSecurityAlertPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>, ManagedDatabaseSecurityAlertPolicyInner>(){

            public ManagedDatabaseSecurityAlertPolicyInner call(ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner> response) {
                return (ManagedDatabaseSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ManagedDatabaseSecurityAlertPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String securityAlertPolicyName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, managedInstanceName, databaseName, "default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedDatabaseSecurityAlertPoliciesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedDatabaseSecurityAlertPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedDatabaseSecurityAlertPolicyInner>(){}.getType()).register(201, new TypeToken<ManagedDatabaseSecurityAlertPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedDatabaseSecurityAlertPolicyInner> listByDatabase(String resourceGroupName, String managedInstanceName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).toBlocking().single();
        return new PagedList<ManagedDatabaseSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ManagedDatabaseSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, ListOperationCallback<ManagedDatabaseSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, managedInstanceName, databaseName).map((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>, Page<ManagedDatabaseSecurityAlertPolicyInner>>(){

            public Page<ManagedDatabaseSecurityAlertPolicyInner> call(ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByDatabase(resourceGroupName, managedInstanceName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedDatabaseSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedDatabaseSecurityAlertPolicyInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedDatabaseSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ManagedDatabaseSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<ManagedDatabaseSecurityAlertPolicyInner>> serviceFuture, ListOperationCallback<ManagedDatabaseSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>, Page<ManagedDatabaseSecurityAlertPolicyInner>>(){

            public Page<ManagedDatabaseSecurityAlertPolicyInner> call(ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedDatabaseSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedDatabaseSecurityAlertPoliciesInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedDatabaseSecurityAlertPolicyInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedDatabaseSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedDatabaseSecurityAlertPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseSecurityAlertPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="securityAlertPolicyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseSecurityAlertPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="securityAlertPolicyName") String var4, @Path(value="subscriptionId") String var5, @Body ManagedDatabaseSecurityAlertPolicyInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseSecurityAlertPolicies listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/securityAlertPolicies")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedDatabaseSecurityAlertPolicies listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

