/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.TransparentDataEncryptionActivity;
import com.microsoft.azure.management.sql.TransparentDataEncryptionStates;
import com.microsoft.azure.management.sql.implementation.DatabasesInner;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionActivityImpl;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionActivityInner;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionInner;
import java.util.List;

@LangDefinition
class TransparentDataEncryptionImpl
extends WrapperImpl<TransparentDataEncryptionInner>
implements TransparentDataEncryption {
    private final ResourceId resourceId = ResourceId.fromString((String)((TransparentDataEncryptionInner)this.inner()).id());
    private final DatabasesInner databasesInner;

    protected TransparentDataEncryptionImpl(TransparentDataEncryptionInner innerObject, DatabasesInner databasesInner) {
        super((Object)innerObject);
        this.databasesInner = databasesInner;
    }

    public String name() {
        return this.resourceId.name();
    }

    public String id() {
        return this.resourceId.id();
    }

    public String resourceGroupName() {
        return this.resourceId.resourceGroupName();
    }

    @Override
    public String sqlServerName() {
        return this.resourceId.parent().parent().name();
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public TransparentDataEncryptionStates status() {
        return ((TransparentDataEncryptionInner)this.inner()).status();
    }

    @Override
    public TransparentDataEncryption updateStatus(TransparentDataEncryptionStates transparentDataEncryptionState) {
        ((TransparentDataEncryptionInner)this.inner()).withStatus(transparentDataEncryptionState);
        this.setInner(this.databasesInner.createOrUpdateTransparentDataEncryptionConfiguration(this.resourceGroupName(), this.sqlServerName(), this.databaseName(), ((TransparentDataEncryptionInner)this.inner()).status()));
        return this;
    }

    @Override
    public List<TransparentDataEncryptionActivity> listActivities() {
        PagedListConverter<TransparentDataEncryptionActivityInner, TransparentDataEncryptionActivity> converter = new PagedListConverter<TransparentDataEncryptionActivityInner, TransparentDataEncryptionActivity>(){

            public TransparentDataEncryptionActivity typeConvert(TransparentDataEncryptionActivityInner transparentDataEncryptionActivityInner) {
                return new TransparentDataEncryptionActivityImpl(transparentDataEncryptionActivityInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(this.databasesInner.listTransparentDataEncryptionActivity(this.resourceGroupName(), this.sqlServerName(), this.databaseName())));
    }
}

