/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildImpl;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.ServerFirewallRuleInner;
import com.microsoft.azure.management.sql.implementation.ServersInner;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlFirewallRuleImpl
extends IndependentChildImpl<SqlFirewallRule, SqlServer, ServerFirewallRuleInner, SqlFirewallRuleImpl, SqlServerManager>
implements SqlFirewallRule,
SqlFirewallRule.Definition,
SqlFirewallRule.Update,
IndependentChild.DefinitionStages.WithParentResource<SqlFirewallRule, SqlServer> {
    private final ServersInner innerCollection;

    protected SqlFirewallRuleImpl(String name, ServerFirewallRuleInner innerObject, ServersInner innerCollection, SqlServerManager manager) {
        super(name, (Object)innerObject, (Object)manager);
        this.innerCollection = innerCollection;
    }

    @Override
    public String sqlServerName() {
        return this.parentName;
    }

    @Override
    public String startIPAddress() {
        return ((ServerFirewallRuleInner)this.inner()).startIpAddress();
    }

    @Override
    public String endIPAddress() {
        return ((ServerFirewallRuleInner)this.inner()).endIpAddress();
    }

    @Override
    public String kind() {
        return ((ServerFirewallRuleInner)this.inner()).kind();
    }

    @Override
    public Region region() {
        return Region.findByLabelOrName((String)((ServerFirewallRuleInner)this.inner()).location());
    }

    @Override
    public void delete() {
        this.innerCollection.deleteFirewallRule(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    protected Observable<ServerFirewallRuleInner> getInnerAsync() {
        return this.innerCollection.getFirewallRuleAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    protected Observable<SqlFirewallRule> createChildResourceAsync() {
        final SqlFirewallRuleImpl self = this;
        return this.innerCollection.createOrUpdateFirewallRuleAsync(this.resourceGroupName(), this.sqlServerName(), this.name(), (ServerFirewallRuleInner)this.inner()).map((Func1)new Func1<ServerFirewallRuleInner, SqlFirewallRule>(){

            public SqlFirewallRule call(ServerFirewallRuleInner serverFirewallRuleInner) {
                SqlFirewallRuleImpl.this.setInner(serverFirewallRuleInner);
                return self;
            }
        });
    }

    @Override
    public SqlFirewallRuleImpl withStartIPAddress(String startIPAddress) {
        ((ServerFirewallRuleInner)this.inner()).withStartIpAddress(startIPAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withEndIPAddress(String endIPAddress) {
        ((ServerFirewallRuleInner)this.inner()).withEndIpAddress(endIPAddress);
        return this;
    }

    public String id() {
        if (this.inner() != null) {
            return ((ServerFirewallRuleInner)this.inner()).id();
        }
        return null;
    }

    @Override
    public SqlFirewallRuleImpl withIPAddressRange(String startIPAddress, String endIPAddress) {
        this.withStartIPAddress(startIPAddress).withEndIPAddress(endIPAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIPAddress(String ipAddress) {
        ((ServerFirewallRuleInner)this.inner()).withStartIpAddress(ipAddress).withEndIpAddress(ipAddress);
        return this;
    }
}

