/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ManagedInstanceKeyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedInstanceKeysInner {
    private ManagedInstanceKeysService service;
    private SqlManagementClientImpl client;

    public ManagedInstanceKeysInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedInstanceKeysService)retrofit.create(ManagedInstanceKeysService.class);
        this.client = client;
    }

    public PagedList<ManagedInstanceKeyInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>((Page)response.body()){

            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                return ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>(){

            public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceKeysInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        String filter = null;
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), filter, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceKeysInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ManagedInstanceKeyInner> listByInstance(String resourceGroupName, String managedInstanceName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>((Page)response.body()){

            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, String filter, ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                return ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, String filter) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName, filter).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>(){

            public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String filter) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceKeysInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), filter, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceKeysInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceKeyInner get(String resourceGroupName, String managedInstanceName, String keyName) {
        return (ManagedInstanceKeyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceKeyInner> getAsync(String resourceGroupName, String managedInstanceName, String keyName, ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    public Observable<ManagedInstanceKeyInner> getAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map((Func1)new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>(){

            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return (ManagedInstanceKeyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceKeyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceKeyInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceKeyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceKeyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return (ManagedInstanceKeyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedInstanceKeyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters, ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceKeyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>(){

            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return (ManagedInstanceKeyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceKeyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedInstanceKeyInner>(){}.getType());
    }

    public ManagedInstanceKeyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return (ManagedInstanceKeyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters, ServiceCallback<ManagedInstanceKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceKeyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceKeyInner>, ManagedInstanceKeyInner>(){

            public ManagedInstanceKeyInner call(ServiceResponse<ManagedInstanceKeyInner> response) {
                return (ManagedInstanceKeyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceKeyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName, ManagedInstanceKeyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-10-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), parameters, "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceKeyInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceKeysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceKeyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceKeyInner>(){}.getType()).register(201, new TypeToken<ManagedInstanceKeyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName, String keyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String keyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String managedInstanceName, String keyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String keyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName, keyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.beginDelete(resourceGroupName, managedInstanceName, keyName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstanceKeysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceKeyInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceKeyInner>((Page)response.body()){

            public Page<ManagedInstanceKeyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceKeyInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<ManagedInstanceKeyInner>> serviceFuture, ListOperationCallback<ManagedInstanceKeyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(String nextPageLink) {
                return ManagedInstanceKeysInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceKeyInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Page<ManagedInstanceKeyInner>>(){

            public Page<ManagedInstanceKeyInner> call(ServiceResponse<Page<ManagedInstanceKeyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceKeyInner>>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(ServiceResponse<Page<ManagedInstanceKeyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstanceKeysInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstanceKeysInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceKeyInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedInstanceKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$filter") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedInstanceKeyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedInstanceKeyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/keys/{keyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="keyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceKeys listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

