/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.VulnerabilityAssessmentScanTriggerType;
import com.microsoft.azure.management.sql.VulnerabilityAssessmentScanState;
import org.joda.time.DateTime;
import java.util.List;
import com.microsoft.azure.management.sql.VulnerabilityAssessmentScanError;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A vulnerability assessment scan record.
 */
@JsonFlatten
public class VulnerabilityAssessmentScanRecordInner extends ProxyResource {
    /**
     * The scan ID.
     */
    @JsonProperty(value = "properties.scanId", access = JsonProperty.Access.WRITE_ONLY)
    private String scanId;

    /**
     * The scan trigger type. Possible values include: 'OnDemand', 'Recurring'.
     */
    @JsonProperty(value = "properties.triggerType", access = JsonProperty.Access.WRITE_ONLY)
    private VulnerabilityAssessmentScanTriggerType triggerType;

    /**
     * The scan status. Possible values include: 'Passed', 'Failed',
     * 'FailedToRun', 'InProgress'.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private VulnerabilityAssessmentScanState state;

    /**
     * The scan start time (UTC).
     */
    @JsonProperty(value = "properties.startTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime startTime;

    /**
     * The scan end time (UTC).
     */
    @JsonProperty(value = "properties.endTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime endTime;

    /**
     * The scan errors.
     */
    @JsonProperty(value = "properties.errors", access = JsonProperty.Access.WRITE_ONLY)
    private List<VulnerabilityAssessmentScanError> errors;

    /**
     * The scan results storage container path.
     */
    @JsonProperty(value = "properties.storageContainerPath", access = JsonProperty.Access.WRITE_ONLY)
    private String storageContainerPath;

    /**
     * The number of failed security checks.
     */
    @JsonProperty(value = "properties.numberOfFailedSecurityChecks", access = JsonProperty.Access.WRITE_ONLY)
    private Integer numberOfFailedSecurityChecks;

    /**
     * Get the scan ID.
     *
     * @return the scanId value
     */
    public String scanId() {
        return this.scanId;
    }

    /**
     * Get the scan trigger type. Possible values include: 'OnDemand', 'Recurring'.
     *
     * @return the triggerType value
     */
    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.triggerType;
    }

    /**
     * Get the scan status. Possible values include: 'Passed', 'Failed', 'FailedToRun', 'InProgress'.
     *
     * @return the state value
     */
    public VulnerabilityAssessmentScanState state() {
        return this.state;
    }

    /**
     * Get the scan start time (UTC).
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the scan end time (UTC).
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the scan errors.
     *
     * @return the errors value
     */
    public List<VulnerabilityAssessmentScanError> errors() {
        return this.errors;
    }

    /**
     * Get the scan results storage container path.
     *
     * @return the storageContainerPath value
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Get the number of failed security checks.
     *
     * @return the numberOfFailedSecurityChecks value
     */
    public Integer numberOfFailedSecurityChecks() {
        return this.numberOfFailedSecurityChecks;
    }

}
