/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The max per-database DTU capability.
 */
public class ElasticPoolPerDatabaseMaxDtuCapability {
    /**
     * The maximum DTUs per database.
     */
    @JsonProperty(value = "limit", access = JsonProperty.Access.WRITE_ONLY)
    private Long limit;

    /**
     * The status of the capability. Possible values include: 'Visible',
     * 'Available', 'Default', 'Disabled'.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;

    /**
     * The list of supported min database DTUs.
     */
    @JsonProperty(value = "supportedPerDatabaseMinDtus", access = JsonProperty.Access.WRITE_ONLY)
    private List<ElasticPoolPerDatabaseMinDtuCapability> supportedPerDatabaseMinDtus;

    /**
     * Get the maximum DTUs per database.
     *
     * @return the limit value
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Get the status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'.
     *
     * @return the status value
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the list of supported min database DTUs.
     *
     * @return the supportedPerDatabaseMinDtus value
     */
    public List<ElasticPoolPerDatabaseMinDtuCapability> supportedPerDatabaseMinDtus() {
        return this.supportedPerDatabaseMinDtus;
    }

}
