/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsListingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabases;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.DatabasesInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlWarehouseImpl;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlDatabasesImpl
extends IndependentChildResourcesImpl<SqlDatabase, SqlDatabaseImpl, DatabaseInner, DatabasesInner, SqlServerManager, SqlServer>
implements SqlDatabases.SqlDatabaseCreatable,
SupportsGettingByParent<SqlDatabase, SqlServer, SqlServerManager>,
SupportsListingByParent<SqlDatabase, SqlServer, SqlServerManager> {
    protected SqlDatabasesImpl(SqlServerManager manager) {
        super((Object)((SqlManagementClientImpl)((Object)manager.inner())).databases(), (ManagerBase)manager);
    }

    protected SqlDatabaseImpl wrapModel(String name) {
        DatabaseInner inner = new DatabaseInner();
        return new SqlDatabaseImpl(name, inner, (SqlServerManager)this.manager());
    }

    public Observable<SqlDatabase> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((DatabasesInner)this.inner()).getAsync(resourceGroup, parentName, name).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner databaseInner) {
                return SqlDatabasesImpl.this.wrapModel(databaseInner);
            }
        });
    }

    public PagedList<SqlDatabase> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((DatabasesInner)this.inner()).listByServer(resourceGroupName, parentName));
    }

    protected SqlDatabaseImpl wrapModel(DatabaseInner inner) {
        if (inner == null) {
            return null;
        }
        return new SqlWarehouseImpl(inner.name(), inner, (SqlServerManager)this.manager());
    }

    public SqlDatabase.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((DatabasesInner)this.inner()).deleteAsync(groupName, parentName, name).toCompletable();
    }

    @Override
    public SqlDatabase getBySqlServer(String resourceGroup, String sqlServerName, String name) {
        return (SqlDatabase)this.getByParent(resourceGroup, sqlServerName, name);
    }

    @Override
    public SqlDatabase getBySqlServer(SqlServer sqlServer, String name) {
        return (SqlDatabase)this.getByParent((Resource)sqlServer, name);
    }

    @Override
    public List<SqlDatabase> listBySqlServer(String resourceGroupName, String sqlServerName) {
        return this.listByParent(resourceGroupName, sqlServerName);
    }

    @Override
    public List<SqlDatabase> listBySqlServer(SqlServer sqlServer) {
        return this.listByParent((Resource)sqlServer);
    }

    @Override
    public SqlDatabaseImpl definedWithSqlServer(String resourceGroupName, String sqlServerName, String databaseName, Region region) {
        DatabaseInner inner = new DatabaseInner();
        inner.withLocation(region.name());
        return (SqlDatabaseImpl)new SqlDatabaseImpl(databaseName, inner, (SqlServerManager)this.manager()).withExistingParentResource(resourceGroupName, sqlServerName);
    }
}

