/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.sql.ElasticPoolState;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Represents an Azure SQL Database elastic pool.
 */
@JsonFlatten
public class ElasticPoolInner extends Resource {
    /**
     * The creation date of the Azure SQL Elastic Pool (ISO8601 format).
     */
    @JsonProperty(value = "properties.creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationDate;

    /**
     * The state of the Azure SQL Elastic Pool. Possible values include:
     * 'Creating', 'Ready', 'Disabled'.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private ElasticPoolState state;

    /**
     * The edition of the Azure SQL Elastic Pool. Possible values include:
     * 'Basic', 'Standard', 'Premium'.
     */
    @JsonProperty(value = "properties.edition")
    private ElasticPoolEditions edition;

    /**
     * The total shared DTU for the SQL Azure Database Elastic Pool.
     */
    @JsonProperty(value = "properties.dtu")
    private Integer dtu;

    /**
     * The maximum DTU any one SQL Azure Database can consume.
     */
    @JsonProperty(value = "properties.databaseDtuMax")
    private Integer databaseDtuMax;

    /**
     * The minimum DTU all SQL Azure Databases are guaranteed.
     */
    @JsonProperty(value = "properties.databaseDtuMin")
    private Integer databaseDtuMin;

    /**
     * Gets storage limit for the SQL Azure Database Elastic Pool in MB.
     */
    @JsonProperty(value = "properties.storageMB")
    private Integer storageMB;

    /**
     * Get the creationDate value.
     *
     * @return the creationDate value
     */
    public DateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the state value.
     *
     * @return the state value
     */
    public ElasticPoolState state() {
        return this.state;
    }

    /**
     * Get the edition value.
     *
     * @return the edition value
     */
    public ElasticPoolEditions edition() {
        return this.edition;
    }

    /**
     * Set the edition value.
     *
     * @param edition the edition value to set
     * @return the ElasticPoolInner object itself.
     */
    public ElasticPoolInner withEdition(ElasticPoolEditions edition) {
        this.edition = edition;
        return this;
    }

    /**
     * Get the dtu value.
     *
     * @return the dtu value
     */
    public Integer dtu() {
        return this.dtu;
    }

    /**
     * Set the dtu value.
     *
     * @param dtu the dtu value to set
     * @return the ElasticPoolInner object itself.
     */
    public ElasticPoolInner withDtu(Integer dtu) {
        this.dtu = dtu;
        return this;
    }

    /**
     * Get the databaseDtuMax value.
     *
     * @return the databaseDtuMax value
     */
    public Integer databaseDtuMax() {
        return this.databaseDtuMax;
    }

    /**
     * Set the databaseDtuMax value.
     *
     * @param databaseDtuMax the databaseDtuMax value to set
     * @return the ElasticPoolInner object itself.
     */
    public ElasticPoolInner withDatabaseDtuMax(Integer databaseDtuMax) {
        this.databaseDtuMax = databaseDtuMax;
        return this;
    }

    /**
     * Get the databaseDtuMin value.
     *
     * @return the databaseDtuMin value
     */
    public Integer databaseDtuMin() {
        return this.databaseDtuMin;
    }

    /**
     * Set the databaseDtuMin value.
     *
     * @param databaseDtuMin the databaseDtuMin value to set
     * @return the ElasticPoolInner object itself.
     */
    public ElasticPoolInner withDatabaseDtuMin(Integer databaseDtuMin) {
        this.databaseDtuMin = databaseDtuMin;
        return this;
    }

    /**
     * Get the storageMB value.
     *
     * @return the storageMB value
     */
    public Integer storageMB() {
        return this.storageMB;
    }

    /**
     * Set the storageMB value.
     *
     * @param storageMB the storageMB value to set
     * @return the ElasticPoolInner object itself.
     */
    public ElasticPoolInner withStorageMB(Integer storageMB) {
        this.storageMB = storageMB;
        return this;
    }

}
