/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for TargetElasticPoolEditions.
 */
public enum TargetElasticPoolEditions {
    /** Enum value Basic. */
    BASIC("Basic"),

    /** Enum value Standard. */
    STANDARD("Standard"),

    /** Enum value Premium. */
    PREMIUM("Premium");

    /** The actual serialized value for a TargetElasticPoolEditions instance. */
    private String value;

    TargetElasticPoolEditions(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TargetElasticPoolEditions instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed TargetElasticPoolEditions object, or null if unable to parse.
     */
    @JsonCreator
    public static TargetElasticPoolEditions fromString(String value) {
        TargetElasticPoolEditions[] items = TargetElasticPoolEditions.values();
        for (TargetElasticPoolEditions item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
