/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SyncDatabaseIdPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncFullSchemaPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncGroupInner;
import com.microsoft.azure.management.sql.implementation.SyncGroupLogPropertiesInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SyncGroupsInner {
    private SyncGroupsService service;
    private SqlManagementClientImpl client;

    public SyncGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (SyncGroupsService)retrofit.create(SyncGroupsService.class);
        this.client = client;
    }

    public PagedList<SyncDatabaseIdPropertiesInner> listSyncDatabaseIds(String locationName) {
        ServiceResponse response = (ServiceResponse)this.listSyncDatabaseIdsSinglePageAsync(locationName).toBlocking().single();
        return new PagedList<SyncDatabaseIdPropertiesInner>((Page)response.body()){

            public Page<SyncDatabaseIdPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsAsync(String locationName, ListOperationCallback<SyncDatabaseIdPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSyncDatabaseIdsSinglePageAsync(locationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsAsync(String locationName) {
        return this.listSyncDatabaseIdsWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>, Page<SyncDatabaseIdPropertiesInner>>(){

            public Page<SyncDatabaseIdPropertiesInner> call(ServiceResponse<Page<SyncDatabaseIdPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> listSyncDatabaseIdsWithServiceResponseAsync(String locationName) {
        return this.listSyncDatabaseIdsSinglePageAsync(locationName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(ServiceResponse<Page<SyncDatabaseIdPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listSyncDatabaseIdsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> listSyncDatabaseIdsSinglePageAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listSyncDatabaseIds(locationName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listSyncDatabaseIdsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncDatabaseIdPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void refreshHubSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.refreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> refreshHubSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.refreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> refreshHubSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.refreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> refreshHubSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.refreshHubSchema(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRefreshHubSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.beginRefreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRefreshHubSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRefreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> beginRefreshHubSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.beginRefreshHubSchemaWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRefreshHubSchemaWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginRefreshHubSchema(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.beginRefreshHubSchemaDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRefreshHubSchemaDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncFullSchemaPropertiesInner> listHubSchemas(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ServiceResponse response = (ServiceResponse)this.listHubSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>((Page)response.body()){

            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listHubSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listHubSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHubSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listHubSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncFullSchemaPropertiesInner>> listHubSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.listHubSchemasWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>(){

            public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listHubSchemasWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.listHubSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listHubSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listHubSchemasSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listHubSchemas(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listHubSchemasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listHubSchemasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncGroupLogPropertiesInner> listLogs(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type) {
        ServiceResponse response = (ServiceResponse)this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type).toBlocking().single();
        return new PagedList<SyncGroupLogPropertiesInner>((Page)response.body()){

            public Page<SyncGroupLogPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncGroupLogPropertiesInner>> listLogsAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, ListOperationCallback<SyncGroupLogPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncGroupLogPropertiesInner>> listLogsAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type) {
        return this.listLogsWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type).map((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Page<SyncGroupLogPropertiesInner>>(){

            public Page<SyncGroupLogPropertiesInner> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type) {
        return this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type).concatMap((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listLogsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (startTime == null) {
            throw new IllegalArgumentException("Parameter startTime is required and cannot be null.");
        }
        if (endTime == null) {
            throw new IllegalArgumentException("Parameter endTime is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        String continuationToken = null;
        return this.service.listLogs(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), startTime, endTime, type, continuationToken, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SyncGroupLogPropertiesInner> listLogs(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, String continuationToken) {
        ServiceResponse response = (ServiceResponse)this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type, continuationToken).toBlocking().single();
        return new PagedList<SyncGroupLogPropertiesInner>((Page)response.body()){

            public Page<SyncGroupLogPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncGroupLogPropertiesInner>> listLogsAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, String continuationToken, ListOperationCallback<SyncGroupLogPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type, continuationToken), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncGroupLogPropertiesInner>> listLogsAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, String continuationToken) {
        return this.listLogsWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type, continuationToken).map((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Page<SyncGroupLogPropertiesInner>>(){

            public Page<SyncGroupLogPropertiesInner> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, String continuationToken) {
        return this.listLogsSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, startTime, endTime, type, continuationToken).concatMap((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listLogsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String startTime, String endTime, String type, String continuationToken) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (startTime == null) {
            throw new IllegalArgumentException("Parameter startTime is required and cannot be null.");
        }
        if (endTime == null) {
            throw new IllegalArgumentException("Parameter endTime is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listLogs(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), startTime, endTime, type, continuationToken, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncGroupLogPropertiesInner>> listLogsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncGroupLogPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancelSync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.cancelSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelSyncAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> cancelSyncAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.cancelSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelSyncWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.cancelSync(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.cancelSyncDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelSyncDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void triggerSync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.triggerSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> triggerSyncAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.triggerSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> triggerSyncAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.triggerSyncWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> triggerSyncWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.triggerSync(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.triggerSyncDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> triggerSyncDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncGroupInner get(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return (SyncGroupInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<SyncGroupInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<SyncGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<SyncGroupInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<SyncGroupInner>, SyncGroupInner>(){

            public SyncGroupInner call(ServiceResponse<SyncGroupInner> response) {
                return (SyncGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncGroupInner>>>(){

            public Observable<ServiceResponse<SyncGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncGroupInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return (SyncGroupInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<SyncGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters, ServiceCallback<SyncGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters), serviceCallback);
    }

    public Observable<SyncGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).map((Func1)new Func1<ServiceResponse<SyncGroupInner>, SyncGroupInner>(){

            public SyncGroupInner call(ServiceResponse<SyncGroupInner> response) {
                return (SyncGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncGroupInner>(){}.getType());
    }

    public SyncGroupInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return (SyncGroupInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<SyncGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters, ServiceCallback<SyncGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters), serviceCallback);
    }

    public Observable<SyncGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).map((Func1)new Func1<ServiceResponse<SyncGroupInner>, SyncGroupInner>(){

            public SyncGroupInner call(ServiceResponse<SyncGroupInner> response) {
                return (SyncGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncGroupInner>>>(){

            public Observable<ServiceResponse<SyncGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncGroupInner>(){}.getType()).register(201, new TypeToken<SyncGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SyncGroupInner update(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return (SyncGroupInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<SyncGroupInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters, ServiceCallback<SyncGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters), serviceCallback);
    }

    public Observable<SyncGroupInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).map((Func1)new Func1<ServiceResponse<SyncGroupInner>, SyncGroupInner>(){

            public SyncGroupInner call(ServiceResponse<SyncGroupInner> response) {
                return (SyncGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SyncGroupInner>(){}.getType());
    }

    public SyncGroupInner beginUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return (SyncGroupInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<SyncGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters, ServiceCallback<SyncGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters), serviceCallback);
    }

    public Observable<SyncGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, parameters).map((Func1)new Func1<ServiceResponse<SyncGroupInner>, SyncGroupInner>(){

            public SyncGroupInner call(ServiceResponse<SyncGroupInner> response) {
                return (SyncGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SyncGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, SyncGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (syncGroupName == null) {
            throw new IllegalArgumentException("Parameter syncGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginUpdate(resourceGroupName, serverName, databaseName, syncGroupName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SyncGroupInner>>>(){

            public Observable<ServiceResponse<SyncGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SyncGroupsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SyncGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SyncGroupInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncGroupInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<SyncGroupInner>((Page)response.body()){

            public Page<SyncGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncGroupInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ListOperationCallback<SyncGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncGroupInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Page<SyncGroupInner>>, Page<SyncGroupInner>>(){

            public Page<SyncGroupInner> call(ServiceResponse<Page<SyncGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<SyncGroupInner>>, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(ServiceResponse<Page<SyncGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncGroupInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncDatabaseIdPropertiesInner> listSyncDatabaseIdsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncDatabaseIdPropertiesInner>((Page)response.body()){

            public Page<SyncDatabaseIdPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsNextAsync(String nextPageLink, ServiceFuture<List<SyncDatabaseIdPropertiesInner>> serviceFuture, ListOperationCallback<SyncDatabaseIdPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsNextAsync(String nextPageLink) {
        return this.listSyncDatabaseIdsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>, Page<SyncDatabaseIdPropertiesInner>>(){

            public Page<SyncDatabaseIdPropertiesInner> call(ServiceResponse<Page<SyncDatabaseIdPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> listSyncDatabaseIdsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSyncDatabaseIdsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(ServiceResponse<Page<SyncDatabaseIdPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listSyncDatabaseIdsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> listSyncDatabaseIdsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSyncDatabaseIdsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncDatabaseIdPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listSyncDatabaseIdsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncDatabaseIdPropertiesInner>> listSyncDatabaseIdsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncDatabaseIdPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncFullSchemaPropertiesInner> listHubSchemasNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listHubSchemasNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncFullSchemaPropertiesInner>((Page)response.body()){

            public Page<SyncFullSchemaPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listHubSchemasNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncFullSchemaPropertiesInner>> listHubSchemasNextAsync(String nextPageLink, ServiceFuture<List<SyncFullSchemaPropertiesInner>> serviceFuture, ListOperationCallback<SyncFullSchemaPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listHubSchemasNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listHubSchemasNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncFullSchemaPropertiesInner>> listHubSchemasNextAsync(String nextPageLink) {
        return this.listHubSchemasNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Page<SyncFullSchemaPropertiesInner>>(){

            public Page<SyncFullSchemaPropertiesInner> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listHubSchemasNextWithServiceResponseAsync(String nextPageLink) {
        return this.listHubSchemasNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(ServiceResponse<Page<SyncFullSchemaPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listHubSchemasNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> listHubSchemasNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listHubSchemasNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncFullSchemaPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listHubSchemasNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncFullSchemaPropertiesInner>> listHubSchemasNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncFullSchemaPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncGroupLogPropertiesInner> listLogsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listLogsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncGroupLogPropertiesInner>((Page)response.body()){

            public Page<SyncGroupLogPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncGroupLogPropertiesInner>> listLogsNextAsync(String nextPageLink, ServiceFuture<List<SyncGroupLogPropertiesInner>> serviceFuture, ListOperationCallback<SyncGroupLogPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listLogsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listLogsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncGroupLogPropertiesInner>> listLogsNextAsync(String nextPageLink) {
        return this.listLogsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Page<SyncGroupLogPropertiesInner>>(){

            public Page<SyncGroupLogPropertiesInner> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listLogsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncGroupLogPropertiesInner>>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(ServiceResponse<Page<SyncGroupLogPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listLogsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> listLogsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listLogsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupLogPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listLogsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncGroupLogPropertiesInner>> listLogsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncGroupLogPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SyncGroupInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SyncGroupInner>((Page)response.body()){

            public Page<SyncGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SyncGroupsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SyncGroupInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<SyncGroupInner>> serviceFuture, ListOperationCallback<SyncGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(String nextPageLink) {
                return SyncGroupsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SyncGroupInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SyncGroupInner>>, Page<SyncGroupInner>>(){

            public Page<SyncGroupInner> call(ServiceResponse<Page<SyncGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SyncGroupInner>>, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(ServiceResponse<Page<SyncGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SyncGroupsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SyncGroupInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SyncGroupInner>>>>(){

            public Observable<ServiceResponse<Page<SyncGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SyncGroupsInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SyncGroupInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SyncGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SyncGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listSyncDatabaseIds"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/syncDatabaseIds")
        public Observable<Response<ResponseBody>> listSyncDatabaseIds(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups refreshHubSchema"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/refreshHubSchema")
        public Observable<Response<ResponseBody>> refreshHubSchema(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups beginRefreshHubSchema"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/refreshHubSchema")
        public Observable<Response<ResponseBody>> beginRefreshHubSchema(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listHubSchemas"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/hubSchemas")
        public Observable<Response<ResponseBody>> listHubSchemas(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listLogs"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/logs")
        public Observable<Response<ResponseBody>> listLogs(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="startTime") String var6, @Query(value="endTime") String var7, @Query(value="type") String var8, @Query(value="continuationToken") String var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups cancelSync"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/cancelSync")
        public Observable<Response<ResponseBody>> cancelSync(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups triggerSync"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/triggerSync")
        public Observable<Response<ResponseBody>> triggerSync(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Body SyncGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Body SyncGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Body SyncGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="syncGroupName") String var4, @Path(value="subscriptionId") String var5, @Body SyncGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listSyncDatabaseIdsNext"})
        @GET
        public Observable<Response<ResponseBody>> listSyncDatabaseIdsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listHubSchemasNext"})
        @GET
        public Observable<Response<ResponseBody>> listHubSchemasNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listLogsNext"})
        @GET
        public Observable<Response<ResponseBody>> listLogsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SyncGroups listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

