/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlDatabaseOperationsImpl
implements SqlDatabaseOperations,
SqlDatabaseOperations.SqlDatabaseActionsDefinition {
    private SqlServerManager manager;
    private SqlServerImpl sqlServer;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases;

    SqlDatabaseOperationsImpl(SqlServerImpl parent, SqlServerManager manager) {
        Objects.requireNonNull(manager);
        this.sqlServer = parent;
        this.manager = manager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.sqlServer.taskGroup(), manager, "SqlDatabase");
    }

    SqlDatabaseOperationsImpl(SqlServerManager manager) {
        Objects.requireNonNull(manager);
        this.manager = manager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(null, manager, "SqlDatabase");
    }

    @Override
    public SqlDatabase getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        DatabaseInner inner = ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, this.manager) : null;
    }

    @Override
    public Observable<SqlDatabase> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().getAsync(resourceGroupName, sqlServerName, name).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner inner) {
                return new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, SqlDatabaseOperationsImpl.this.manager);
            }
        });
    }

    @Override
    public SqlDatabase getBySqlServer(SqlServer sqlServer, String name) {
        if (sqlServer == null) {
            return null;
        }
        DatabaseInner inner = ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.manager) : null;
    }

    @Override
    public Observable<SqlDatabase> getBySqlServerAsync(final SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).databases().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner inner) {
                return new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, SqlDatabaseOperationsImpl.this.manager);
            }
        });
    }

    @Override
    public SqlDatabase get(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public Observable<SqlDatabase> getAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public SqlDatabase getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Observable<SqlDatabase> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Completable deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().deleteAsync(resourceGroupName, sqlServerName, name).toCompletable();
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        this.deleteBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.deleteBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void delete(String name) {
        if (this.sqlServer != null) {
            this.deleteBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
        }
    }

    @Override
    public Completable deleteAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.deleteBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public List<SqlDatabase> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlDatabaseImpl> databasesSet = new ArrayList<SqlDatabaseImpl>();
        for (DatabaseInner inner : ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().listByServer(resourceGroupName, sqlServerName)) {
            databasesSet.add(new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, this.manager));
        }
        return Collections.unmodifiableList(databasesSet);
    }

    @Override
    public Observable<SqlDatabase> listBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        return ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().listByServerAsync(resourceGroupName, sqlServerName).flatMap((Func1)new Func1<List<DatabaseInner>, Observable<DatabaseInner>>(){

            public Observable<DatabaseInner> call(List<DatabaseInner> databaseInners) {
                return Observable.from(databaseInners);
            }
        }).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner inner) {
                return new SqlDatabaseImpl(resourceGroupName, sqlServerName, inner.location(), inner.name(), inner, SqlDatabaseOperationsImpl.this.manager);
            }
        });
    }

    @Override
    public List<SqlDatabase> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlDatabaseImpl> firewallRuleSet = new ArrayList<SqlDatabaseImpl>();
        if (sqlServer != null) {
            for (DatabaseInner inner : ((SqlManagementClientImpl)((Object)this.manager.inner())).databases().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
                firewallRuleSet.add(new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.manager));
            }
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public Observable<SqlDatabase> listBySqlServerAsync(final SqlServer sqlServer) {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).databases().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).flatMap((Func1)new Func1<List<DatabaseInner>, Observable<DatabaseInner>>(){

            public Observable<DatabaseInner> call(List<DatabaseInner> databaseInners) {
                return Observable.from(databaseInners);
            }
        }).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner inner) {
                return new SqlDatabaseImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public List<SqlDatabase> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public Observable<SqlDatabase> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public SqlDatabaseImpl define(String name) {
        SqlDatabaseImpl result = this.sqlDatabases.defineIndependentDatabase(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

