/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.SensitivityLabelSource;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SensitivityLabelInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SensitivityLabelsInner {
    private SensitivityLabelsService service;
    private SqlManagementClientImpl client;

    public SensitivityLabelsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (SensitivityLabelsService)retrofit.create(SensitivityLabelsService.class);
        this.client = client;
    }

    public PagedList<SensitivityLabelInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<SensitivityLabelInner>((Page)response.body()){

            public Page<SensitivityLabelInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SensitivityLabelInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ListOperationCallback<SensitivityLabelInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(String nextPageLink) {
                return SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SensitivityLabelInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Page<SensitivityLabelInner>>(){

            public Page<SensitivityLabelInner> call(ServiceResponse<Page<SensitivityLabelInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(ServiceResponse<Page<SensitivityLabelInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SensitivityLabelsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        String filter = null;
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), filter, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SensitivityLabelsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SensitivityLabelInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, filter).toBlocking().single();
        return new PagedList<SensitivityLabelInner>((Page)response.body()){

            public Page<SensitivityLabelInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SensitivityLabelInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, String filter, ListOperationCallback<SensitivityLabelInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(String nextPageLink) {
                return SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SensitivityLabelInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, String filter) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName, filter).map((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Page<SensitivityLabelInner>>(){

            public Page<SensitivityLabelInner> call(ServiceResponse<Page<SensitivityLabelInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String filter) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(ServiceResponse<Page<SensitivityLabelInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SensitivityLabelsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), filter, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SensitivityLabelsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SensitivityLabelInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SensitivityLabelInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SensitivityLabelInner get(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        return (SensitivityLabelInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource).toBlocking().single()).body();
    }

    public ServiceFuture<SensitivityLabelInner> getAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource, ServiceCallback<SensitivityLabelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource), serviceCallback);
    }

    public Observable<SensitivityLabelInner> getAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource).map((Func1)new Func1<ServiceResponse<SensitivityLabelInner>, SensitivityLabelInner>(){

            public SensitivityLabelInner call(ServiceResponse<SensitivityLabelInner> response) {
                return (SensitivityLabelInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SensitivityLabelInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("Parameter columnName is required and cannot be null.");
        }
        if (sensitivityLabelSource == null) {
            throw new IllegalArgumentException("Parameter sensitivityLabelSource is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SensitivityLabelInner>>>(){

            public Observable<ServiceResponse<SensitivityLabelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SensitivityLabelsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SensitivityLabelInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SensitivityLabelInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SensitivityLabelInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        return (SensitivityLabelInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<SensitivityLabelInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters, ServiceCallback<SensitivityLabelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, parameters), serviceCallback);
    }

    public Observable<SensitivityLabelInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, parameters).map((Func1)new Func1<ServiceResponse<SensitivityLabelInner>, SensitivityLabelInner>(){

            public SensitivityLabelInner call(ServiceResponse<SensitivityLabelInner> response) {
                return (SensitivityLabelInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SensitivityLabelInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("Parameter columnName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String sensitivityLabelSource = "current";
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, "current", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SensitivityLabelInner>>>(){

            public Observable<ServiceResponse<SensitivityLabelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SensitivityLabelsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SensitivityLabelInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SensitivityLabelInner>(){}.getType()).register(201, new TypeToken<SensitivityLabelInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String schemaName, String tableName, String columnName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Parameter schemaName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("Parameter columnName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String sensitivityLabelSource = "current";
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, databaseName, schemaName, tableName, columnName, "current", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SensitivityLabelsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SensitivityLabelInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SensitivityLabelInner>((Page)response.body()){

            public Page<SensitivityLabelInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SensitivityLabelInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<SensitivityLabelInner>> serviceFuture, ListOperationCallback<SensitivityLabelInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(String nextPageLink) {
                return SensitivityLabelsInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SensitivityLabelInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Page<SensitivityLabelInner>>(){

            public Page<SensitivityLabelInner> call(ServiceResponse<Page<SensitivityLabelInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SensitivityLabelInner>>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(ServiceResponse<Page<SensitivityLabelInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SensitivityLabelsInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SensitivityLabelInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SensitivityLabelInner>>>>(){

            public Observable<ServiceResponse<Page<SensitivityLabelInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SensitivityLabelsInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SensitivityLabelInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SensitivityLabelInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SensitivityLabelsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SensitivityLabels listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sensitivityLabels")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="$filter") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SensitivityLabels get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="schemaName") String var4, @Path(value="tableName") String var5, @Path(value="columnName") String var6, @Path(value="sensitivityLabelSource") SensitivityLabelSource var7, @Path(value="subscriptionId") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SensitivityLabels createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="schemaName") String var4, @Path(value="tableName") String var5, @Path(value="columnName") String var6, @Path(value="sensitivityLabelSource") String var7, @Path(value="subscriptionId") String var8, @Body SensitivityLabelInner var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SensitivityLabels delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="schemaName") String var4, @Path(value="tableName") String var5, @Path(value="columnName") String var6, @Path(value="sensitivityLabelSource") String var7, @Path(value="subscriptionId") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.SensitivityLabels listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

