/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.PolicyAssignment;
import com.microsoft.azure.management.resources.PolicyAssignments;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.management.resources.implementation.PolicyAssignmentImpl;
import com.microsoft.azure.management.resources.implementation.PolicyAssignmentInner;
import com.microsoft.azure.management.resources.implementation.PolicyAssignmentsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

final class PolicyAssignmentsImpl
extends CreatableWrappersImpl<PolicyAssignment, PolicyAssignmentImpl, PolicyAssignmentInner>
implements PolicyAssignments {
    private final PolicyAssignmentsInner client;

    PolicyAssignmentsImpl(PolicyAssignmentsInner innerClient) {
        this.client = innerClient;
    }

    @Override
    public PagedList<PolicyAssignment> list() {
        return this.wrapList(this.client.list());
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        return this.client.deleteByIdAsync(id).toCompletable();
    }

    @Override
    public PolicyAssignmentImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    protected PolicyAssignmentImpl wrapModel(String name) {
        return new PolicyAssignmentImpl(new PolicyAssignmentInner().withName(name).withDisplayName(name), this.client);
    }

    @Override
    protected PolicyAssignmentImpl wrapModel(PolicyAssignmentInner inner) {
        if (inner == null) {
            return null;
        }
        return new PolicyAssignmentImpl(inner, this.client);
    }

    @Override
    public PagedList<PolicyAssignment> listByResource(String resourceId) {
        return this.wrapList(this.client.listForResource(ResourceUtils.groupFromResourceId(resourceId), ResourceUtils.resourceProviderFromResourceId(resourceId), ResourceUtils.relativePathFromResourceId(ResourceUtils.parentResourceIdFromResourceId(resourceId)), ResourceUtils.resourceTypeFromResourceId(resourceId), ResourceUtils.nameFromResourceId(resourceId)));
    }

    @Override
    public PolicyAssignment getById(String id) {
        return (PolicyAssignment)this.getByIdAsync(id).toBlocking().last();
    }

    @Override
    public Observable<PolicyAssignment> getByIdAsync(String id) {
        return this.client.getByIdAsync(id).map((Func1)new Func1<PolicyAssignmentInner, PolicyAssignment>(){

            public PolicyAssignment call(PolicyAssignmentInner policyAssignmentInner) {
                return PolicyAssignmentsImpl.this.wrapModel(policyAssignmentInner);
            }
        });
    }

    @Override
    public ServiceFuture<PolicyAssignment> getByIdAsync(String id, ServiceCallback<PolicyAssignment> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public PagedList<PolicyAssignment> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(this.client.listByResourceGroup(resourceGroupName));
    }

    @Override
    public Observable<PolicyAssignment> listAsync() {
        return this.wrapPageAsync(this.client.listAsync());
    }

    @Override
    public Observable<PolicyAssignment> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(this.client.listByResourceGroupAsync(resourceGroupName));
    }
}

