/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.slf4j.LoggerFactory;

public class ResourceManagerThrottlingInterceptor
implements Interceptor {
    private static final String LOGGING_HEADER = "x-ms-logging-context";
    private static final ReentrantLock REENTRANT_LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            ReentrantLock reentrantLock = REENTRANT_LOCK;
            synchronized (reentrantLock) {
                if (REENTRANT_LOCK.isLocked()) {
                    REENTRANT_LOCK.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Response response = chain.proceed(chain.request());
        if (response.code() != 429) {
            return response;
        }
        try {
            ReentrantLock reentrantLock = REENTRANT_LOCK;
            synchronized (reentrantLock) {
                if (REENTRANT_LOCK.isLocked()) {
                    REENTRANT_LOCK.wait();
                    return chain.proceed(chain.request());
                }
                REENTRANT_LOCK.lock();
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String retryAfterHeader = response.header("Retry-After");
            int retryAfter = 0;
            if (retryAfterHeader != null) {
                retryAfter = Integer.parseInt(retryAfterHeader);
            }
            if (retryAfter <= 0 && (matcher = (pattern = Pattern.compile("try again after '([0-9]*)' minutes", 2)).matcher(this.content(response.body()))).find()) {
                retryAfter = (int)TimeUnit.MINUTES.toSeconds(Integer.parseInt(matcher.group(1)));
            }
            if (retryAfter > 0) {
                String context = chain.request().header(LOGGING_HEADER);
                if (context == null) {
                    context = "";
                }
                LoggerFactory.getLogger((String)context).info("Azure Resource Manager read/write per hour limit reached. Will retry in: " + retryAfter + " seconds");
                SdkContext.sleep((int)(TimeUnit.SECONDS.toMillis(retryAfter) + 100L));
            }
            Response response2 = chain.proceed(chain.request());
            return response2;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            ReentrantLock reentrantLock = REENTRANT_LOCK;
            synchronized (reentrantLock) {
                REENTRANT_LOCK.unlock();
                REENTRANT_LOCK.notifyAll();
            }
        }
    }

    private String content(ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return null;
        }
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        return buffer.readUtf8();
    }
}

