/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGraph;
import com.microsoft.azure.management.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.IndexableTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskCancelledException;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroupEntry;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroupTerminateOnErrorStrategy;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Completable;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class TaskGroup
extends DAGraph<TaskItem, TaskGroupEntry<TaskItem>>
implements Indexable {
    private final TaskGroupEntry<TaskItem> rootTaskEntry;
    private TaskGroupTerminateOnErrorStrategy taskGroupTerminateOnErrorStrategy;
    private AtomicBoolean isGroupCancelled;
    private final TaskCancelledException taskCancelledException = new TaskCancelledException();
    protected ProxyTaskGroupWrapper proxyTaskGroupWrapper;

    private TaskGroup(TaskGroupEntry<TaskItem> rootTaskEntry) {
        super(rootTaskEntry);
        this.isGroupCancelled = new AtomicBoolean(false);
        this.rootTaskEntry = rootTaskEntry;
        this.proxyTaskGroupWrapper = new ProxyTaskGroupWrapper(this);
    }

    public TaskGroup(String rootTaskItemId, TaskItem rootTaskItem) {
        this(new TaskGroupEntry<TaskItem>(rootTaskItemId, rootTaskItem));
    }

    public TaskGroup(IndexableTaskItem rootTaskItem) {
        this(new TaskGroupEntry<TaskItem>(rootTaskItem.key(), rootTaskItem));
    }

    @Override
    public String key() {
        return this.rootTaskEntry.key();
    }

    public Indexable taskResult(String taskId) {
        TaskGroupEntry taskGroupEntry = (TaskGroupEntry)super.getNode(taskId);
        if (taskGroupEntry != null) {
            return taskGroupEntry.taskResult();
        }
        if (!this.proxyTaskGroupWrapper.isActive()) {
            throw new IllegalArgumentException("A dependency task with id '" + taskId + "' is not found");
        }
        taskGroupEntry = (TaskGroupEntry)this.proxyTaskGroupWrapper.proxyTaskGroup.getNode(taskId);
        if (taskGroupEntry != null) {
            return taskGroupEntry.taskResult();
        }
        throw new IllegalArgumentException("A dependency task or 'post-run' dependent task with with id '" + taskId + "' not found");
    }

    public boolean dependsOn(TaskGroup taskGroup) {
        return this.nodeTable.containsKey(taskGroup.root().key());
    }

    @Override
    protected TaskGroupEntry<TaskItem> root() {
        return this.rootTaskEntry;
    }

    public String addDependency(FunctionalTaskItem dependencyTaskItem) {
        IndexableTaskItem dependency = IndexableTaskItem.create(dependencyTaskItem);
        this.addDependency(dependency);
        return dependency.key();
    }

    public void addDependency(HasTaskGroup hasTaskGroup) {
        this.addDependencyTaskGroup(hasTaskGroup.taskGroup());
    }

    public void addDependencyTaskGroup(TaskGroup dependencyTaskGroup) {
        if (dependencyTaskGroup.proxyTaskGroupWrapper.isActive()) {
            dependencyTaskGroup.proxyTaskGroupWrapper.addDependentTaskGroup(this);
        } else {
            TaskGroup dependencyGraph = dependencyTaskGroup;
            super.addDependencyGraph(dependencyGraph);
        }
    }

    public String addPostRunDependent(FunctionalTaskItem dependentTaskItem) {
        IndexableTaskItem taskItem = IndexableTaskItem.create(dependentTaskItem);
        this.addPostRunDependent(taskItem);
        return taskItem.key();
    }

    public void addPostRunDependent(HasTaskGroup hasTaskGroup) {
        this.addPostRunDependentTaskGroup(hasTaskGroup.taskGroup());
    }

    public void addPostRunDependentTaskGroup(TaskGroup dependentTaskGroup) {
        this.proxyTaskGroupWrapper.addPostRunTaskGroupForActualTaskGroup(dependentTaskGroup);
    }

    public Observable<Indexable> invokeAsync(final InvocationContext context) {
        if (this.proxyTaskGroupWrapper.isActive()) {
            return this.proxyTaskGroupWrapper.invokeAsync(context);
        }
        if (!this.isPreparer()) {
            return Observable.error((Throwable)new IllegalStateException("invokeAsync(cxt) can be called only from root TaskGroup"));
        }
        this.taskGroupTerminateOnErrorStrategy = context.terminateOnErrorStrategy();
        return Observable.defer((Func0)new Func0<Observable<Indexable>>(){

            public Observable<Indexable> call() {
                TaskGroup.this.isGroupCancelled.set(false);
                TaskGroup.this.prepareTasks();
                return TaskGroup.this.invokeReadyTasksAsync(context);
            }
        });
    }

    private void prepareTasks() {
        boolean isPreparePending;
        HashSet<String> preparedTasksKeys = new HashSet<String>();
        List<TaskGroupEntry<TaskItem>> entries = this.entriesSnapshot();
        do {
            isPreparePending = false;
            for (TaskGroupEntry<TaskItem> entry : entries) {
                if (preparedTasksKeys.contains(entry.key())) continue;
                ((TaskItem)entry.data()).beforeGroupInvoke();
                preparedTasksKeys.add(entry.key());
            }
            int prevSize = entries.size();
            entries = this.entriesSnapshot();
            if (entries.size() <= prevSize) continue;
            isPreparePending = true;
        } while (isPreparePending);
        super.prepareForEnumeration();
    }

    private List<TaskGroupEntry<TaskItem>> entriesSnapshot() {
        ArrayList<TaskGroupEntry<TaskItem>> entries = new ArrayList<TaskGroupEntry<TaskItem>>();
        super.prepareForEnumeration();
        TaskGroupEntry current = (TaskGroupEntry)super.getNext();
        while (current != null) {
            entries.add(current);
            super.reportCompletion(current);
            current = (TaskGroupEntry)super.getNext();
        }
        return entries;
    }

    private Observable<Indexable> invokeReadyTasksAsync(InvocationContext context) {
        TaskGroupEntry readyTaskEntry = (TaskGroupEntry)super.getNext();
        ArrayList<Observable<Indexable>> observables = new ArrayList<Observable<Indexable>>();
        while (readyTaskEntry != null) {
            TaskGroupEntry currentEntry = readyTaskEntry;
            TaskItem currentTaskItem = (TaskItem)currentEntry.data();
            if (currentTaskItem instanceof ProxyTaskItem) {
                observables.add(this.invokeAfterPostRunAsync(currentEntry, context));
            } else {
                observables.add(this.invokeTaskAsync(currentEntry, context));
            }
            readyTaskEntry = (TaskGroupEntry)super.getNext();
        }
        return Observable.mergeDelayError(observables);
    }

    private Observable<Indexable> invokeTaskAsync(final TaskGroupEntry<TaskItem> entry, final InvocationContext context) {
        return Observable.defer((Func0)new Func0<Observable<Indexable>>(){

            public Observable<Indexable> call() {
                if (TaskGroup.this.isGroupCancelled.get()) {
                    return TaskGroup.this.processFaultedTaskAsync(entry, TaskGroup.this.taskCancelledException, context);
                }
                boolean ignoreCachedResult = TaskGroup.this.isRootEntry(entry) || entry.proxy() != null && TaskGroup.this.isRootEntry(entry.proxy());
                Observable<Indexable> taskObservable = entry.invokeTaskAsync(ignoreCachedResult, context);
                Func1<Indexable, Observable<Indexable>> onResult = new Func1<Indexable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Indexable taskResult) {
                        return Observable.just((Object)taskResult);
                    }
                };
                Func1<Throwable, Observable<Indexable>> onError = new Func1<Throwable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Throwable taskError) {
                        return TaskGroup.this.processFaultedTaskAsync(entry, taskError, context);
                    }
                };
                Func0<Observable<Indexable>> onComplete = new Func0<Observable<Indexable>>(){

                    public Observable<Indexable> call() {
                        return TaskGroup.this.processCompletedTaskAsync(entry, context);
                    }
                };
                return taskObservable.flatMap((Func1)onResult, (Func1)onError, (Func0)onComplete);
            }
        });
    }

    private Observable<Indexable> invokeAfterPostRunAsync(final TaskGroupEntry<TaskItem> entry, final InvocationContext context) {
        return Observable.defer((Func0)new Func0<Observable<Indexable>>(){

            public Observable<Indexable> call() {
                final ProxyTaskItem proxyTaskItem = (ProxyTaskItem)entry.data();
                if (proxyTaskItem == null) {
                    return Observable.empty();
                }
                final boolean isFaulted = entry.hasFaultedDescentDependencyTasks() || TaskGroup.this.isGroupCancelled.get();
                Observable postRunObservable = proxyTaskItem.invokeAfterPostRunAsync(isFaulted).toObservable();
                Func1<Throwable, Observable<Indexable>> onError = new Func1<Throwable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Throwable error) {
                        return TaskGroup.this.processFaultedTaskAsync(entry, error, context);
                    }
                };
                Func0<Observable<Indexable>> onComplete = new Func0<Observable<Indexable>>(){

                    public Observable<Indexable> call() {
                        if (isFaulted) {
                            if (entry.hasFaultedDescentDependencyTasks()) {
                                return TaskGroup.this.processFaultedTaskAsync(entry, new ErroredDependencyTaskException(), context);
                            }
                            return TaskGroup.this.processFaultedTaskAsync(entry, TaskGroup.this.taskCancelledException, context);
                        }
                        return Observable.concat((Observable)Observable.just((Object)proxyTaskItem.result()), (Observable)TaskGroup.this.processCompletedTaskAsync(entry, context));
                    }
                };
                return postRunObservable.flatMap(null, (Func1)onError, (Func0)onComplete);
            }
        });
    }

    private Observable<Indexable> processCompletedTaskAsync(TaskGroupEntry<TaskItem> completedEntry, InvocationContext context) {
        this.reportCompletion(completedEntry);
        if (this.isRootEntry(completedEntry)) {
            return Observable.empty();
        }
        return this.invokeReadyTasksAsync(context);
    }

    private Observable<Indexable> processFaultedTaskAsync(TaskGroupEntry<TaskItem> faultedEntry, Throwable throwable, InvocationContext context) {
        this.markGroupAsCancelledIfTerminationStrategyIsIPTC();
        this.reportError(faultedEntry, throwable);
        if (this.isRootEntry(faultedEntry)) {
            if (TaskGroup.shouldPropagateException(throwable)) {
                return this.toErrorObservable(throwable);
            }
            return Observable.empty();
        }
        if (TaskGroup.shouldPropagateException(throwable)) {
            return Observable.concatDelayError(this.invokeReadyTasksAsync(context), this.toErrorObservable(throwable));
        }
        return this.invokeReadyTasksAsync(context);
    }

    private void markGroupAsCancelledIfTerminationStrategyIsIPTC() {
        this.isGroupCancelled.set(this.taskGroupTerminateOnErrorStrategy == TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_IN_PROGRESS_TASKS_COMPLETION);
    }

    private boolean isRootEntry(TaskGroupEntry<TaskItem> taskGroupEntry) {
        return this.isRootNode(taskGroupEntry);
    }

    private static boolean shouldPropagateException(Throwable throwable) {
        return !(throwable instanceof ErroredDependencyTaskException) && !(throwable instanceof TaskCancelledException);
    }

    private Observable<Indexable> toErrorObservable(Throwable throwable) {
        return Observable.error((Throwable)throwable);
    }

    public InvocationContext newInvocationContext() {
        return new InvocationContext(this);
    }

    private static final class ProxyTaskItem
    implements TaskItem {
        private final TaskItem actualTaskItem;

        private ProxyTaskItem(TaskItem actualTaskItem) {
            this.actualTaskItem = actualTaskItem;
        }

        @Override
        public Indexable result() {
            return this.actualTaskItem.result();
        }

        @Override
        public void beforeGroupInvoke() {
        }

        @Override
        public boolean isHot() {
            return this.actualTaskItem.isHot();
        }

        @Override
        public Observable<Indexable> invokeAsync(InvocationContext context) {
            return Observable.just((Object)this.actualTaskItem.result());
        }

        @Override
        public Completable invokeAfterPostRunAsync(final boolean isGroupFaulted) {
            if (this.actualTaskItem.isHot()) {
                return Completable.defer((Func0)new Func0<Completable>(){

                    public Completable call() {
                        return ProxyTaskItem.this.actualTaskItem.invokeAfterPostRunAsync(isGroupFaulted).subscribeOn(Schedulers.immediate());
                    }
                });
            }
            return this.actualTaskItem.invokeAfterPostRunAsync(isGroupFaulted).subscribeOn(Schedulers.immediate());
        }
    }

    static final class ProxyTaskGroupWrapper {
        private TaskGroup proxyTaskGroup;
        private final TaskGroup actualTaskGroup;

        ProxyTaskGroupWrapper(TaskGroup actualTaskGroup) {
            this.actualTaskGroup = actualTaskGroup;
        }

        boolean isActive() {
            return this.proxyTaskGroup != null;
        }

        TaskGroup proxyTaskGroup() {
            return this.proxyTaskGroup;
        }

        void addPostRunTaskGroupForActualTaskGroup(TaskGroup postRunTaskGroup) {
            if (this.proxyTaskGroup == null) {
                this.initProxyTaskGroup();
            }
            postRunTaskGroup.addDependencyGraph(this.actualTaskGroup);
            if (postRunTaskGroup.proxyTaskGroupWrapper.isActive()) {
                this.proxyTaskGroup.addDependencyGraph(postRunTaskGroup.proxyTaskGroupWrapper.proxyTaskGroup);
            } else {
                this.proxyTaskGroup.addDependencyGraph(postRunTaskGroup);
            }
        }

        void addDependentTaskGroup(TaskGroup dependentTaskGroup) {
            if (this.proxyTaskGroup == null) {
                throw new IllegalStateException("addDependentTaskGroup() cannot be called in a non-active ProxyTaskGroup");
            }
            dependentTaskGroup.addDependencyGraph(this.proxyTaskGroup);
        }

        Observable<Indexable> invokeAsync(InvocationContext context) {
            if (this.proxyTaskGroup == null) {
                throw new IllegalStateException("invokeAsync(cxt) cannot be called in a non-active ProxyTaskGroup");
            }
            return this.proxyTaskGroup.invokeAsync(context);
        }

        private void initProxyTaskGroup() {
            if (this.proxyTaskGroup == null) {
                ProxyTaskItem proxyTaskItem = new ProxyTaskItem((TaskItem)this.actualTaskGroup.root().data());
                this.proxyTaskGroup = new TaskGroup("proxy-" + this.actualTaskGroup.root().key(), proxyTaskItem);
                if (this.actualTaskGroup.hasParents()) {
                    String atgRootKey = this.actualTaskGroup.root().key();
                    for (DAGraph parentDAG : this.actualTaskGroup.parentDAGs) {
                        ((TaskGroupEntry)parentDAG.root()).removeDependency(atgRootKey);
                        parentDAG.addDependencyGraph(this.proxyTaskGroup);
                    }
                    this.actualTaskGroup.parentDAGs.clear();
                }
                this.proxyTaskGroup.addDependencyGraph(this.actualTaskGroup);
                this.actualTaskGroup.rootTaskEntry.setProxy(this.proxyTaskGroup.rootTaskEntry);
            }
        }
    }

    public static final class InvocationContext {
        private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
        private final TaskGroup taskGroup;
        private TaskGroupTerminateOnErrorStrategy terminateOnErrorStrategy;

        private InvocationContext(TaskGroup taskGroup) {
            this.taskGroup = taskGroup;
        }

        public TaskGroup taskGroup() {
            return this.taskGroup;
        }

        public InvocationContext withTerminateOnErrorStrategy(TaskGroupTerminateOnErrorStrategy strategy) {
            if (this.terminateOnErrorStrategy != null) {
                throw new IllegalStateException("Termination strategy is already set, it is immutable for a specific context");
            }
            this.terminateOnErrorStrategy = strategy;
            return this;
        }

        public TaskGroupTerminateOnErrorStrategy terminateOnErrorStrategy() {
            if (this.terminateOnErrorStrategy == null) {
                return TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_HITTING_LCA_TASK;
            }
            return this.terminateOnErrorStrategy;
        }

        public void put(String key, Object value) {
            this.properties.put(key, value);
        }

        public Object get(String key) {
            return this.properties.get(key);
        }

        public boolean hasKey(String key) {
            return this.get(key) != null;
        }
    }

    public static interface HasTaskGroup {
        public TaskGroup taskGroup();
    }
}

