/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.models.implementation;

import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.IndexableTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public abstract class ExternalChildResourceImpl<FluentModelT extends Indexable, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ChildResourceImpl<InnerModelT, ParentImplT, ParentT>
implements TaskGroup.HasTaskGroup,
ExternalChildResource<FluentModelT, ParentT>,
Refreshable<FluentModelT> {
    private PendingOperation pendingOperation = PendingOperation.None;
    private final String name;
    private final ExternalChildActionTaskItem childAction;

    protected ExternalChildResourceImpl(String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(this);
        this.name = name;
    }

    protected ExternalChildResourceImpl(String key, String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(key, this);
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public PendingOperation pendingOperation() {
        return this.pendingOperation;
    }

    public void setPendingOperation(PendingOperation pendingOperation) {
        this.pendingOperation = pendingOperation;
    }

    public void clear() {
        this.setPendingOperation(PendingOperation.None);
        this.childAction.clear();
    }

    @Override
    public TaskGroup taskGroup() {
        return this.childAction.taskGroup();
    }

    public abstract Observable<FluentModelT> createAsync();

    public abstract Observable<FluentModelT> updateAsync();

    public abstract Observable<Void> deleteAsync();

    public String childResourceKey() {
        return this.name();
    }

    @Override
    public final FluentModelT refresh() {
        return (FluentModelT)((Indexable)this.refreshAsync().toBlocking().last());
    }

    @Override
    public Observable<FluentModelT> refreshAsync() {
        final ExternalChildResourceImpl self = this;
        return this.getInnerAsync().map(new Func1<InnerModelT, FluentModelT>(){

            public FluentModelT call(InnerModelT innerModelT) {
                self.setInner(innerModelT);
                return self;
            }
        });
    }

    protected abstract Observable<InnerModelT> getInnerAsync();

    protected Completable afterPostRunAsync(boolean isGroupFaulted) {
        return Completable.complete();
    }

    private class ExternalChildActionTaskItem
    extends IndexableTaskItem {
        private final ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild;

        ExternalChildActionTaskItem(ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            this.externalChild = externalChild;
        }

        ExternalChildActionTaskItem(String key, ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            super(key);
            this.externalChild = externalChild;
        }

        @Override
        public Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
            switch (this.externalChild.pendingOperation()) {
                case ToBeCreated: {
                    return this.externalChild.createAsync().map(new Func1<FluentModelT, Indexable>(){

                        public Indexable call(FluentModelT fluentModelT) {
                            return fluentModelT;
                        }
                    });
                }
                case ToBeUpdated: {
                    return this.externalChild.updateAsync().map(new Func1<FluentModelT, Indexable>(){

                        public Indexable call(FluentModelT fluentModelT) {
                            return fluentModelT;
                        }
                    });
                }
                case ToBeRemoved: {
                    return this.externalChild.deleteAsync().map((Func1)new Func1<Void, Indexable>(){

                        public Indexable call(Void aVoid) {
                            return ExternalChildActionTaskItem.this.voidIndexable();
                        }
                    });
                }
            }
            return Observable.error((Throwable)new IllegalStateException("No action pending on child resource: " + this.externalChild.name + ", invokeAsync should not be called "));
        }

        @Override
        public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
            return this.externalChild.afterPostRunAsync(isGroupFaulted);
        }
    }

    public static enum PendingOperation {
        None,
        ToBeCreated,
        ToBeUpdated,
        ToBeRemoved;

    }
}

