/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources.implementation;

import java.util.List;
import com.microsoft.azure.management.resources.WhatIfChange;
import com.microsoft.azure.management.resources.ErrorResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Result of the What-If operation. Contains a list of predicted changes and a
 * URL link to get to the next set of results.
 */
@JsonFlatten
public class WhatIfOperationResultInner {
    /**
     * Status of the What-If operation.
     */
    @JsonProperty(value = "status")
    private String status;

    /**
     * List of resource changes predicted by What-If operation.
     */
    @JsonProperty(value = "properties.changes")
    private List<WhatIfChange> changes;

    /**
     * Error when What-If operation fails.
     */
    @JsonProperty(value = "error")
    private ErrorResponse error;

    /**
     * Get status of the What-If operation.
     *
     * @return the status value
     */
    public String status() {
        return this.status;
    }

    /**
     * Set status of the What-If operation.
     *
     * @param status the status value to set
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get list of resource changes predicted by What-If operation.
     *
     * @return the changes value
     */
    public List<WhatIfChange> changes() {
        return this.changes;
    }

    /**
     * Set list of resource changes predicted by What-If operation.
     *
     * @param changes the changes value to set
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withChanges(List<WhatIfChange> changes) {
        this.changes = changes;
        return this;
    }

    /**
     * Get error when What-If operation fails.
     *
     * @return the error value
     */
    public ErrorResponse error() {
        return this.error;
    }

    /**
     * Set error when What-If operation fails.
     *
     * @param error the error value to set
     * @return the WhatIfOperationResultInner object itself.
     */
    public WhatIfOperationResultInner withError(ErrorResponse error) {
        this.error = error;
        return this;
    }

}
