/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtManagementGroupScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtSubscriptionScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtTenantScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfHeaders;
import com.microsoft.azure.management.resources.DeploymentWhatIf;
import com.microsoft.azure.management.resources.ScopedDeployment;
import com.microsoft.azure.management.resources.ScopedDeploymentWhatIf;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;

/**
 * An instance of this class provides access to all the operations defined
 * in Deployments.
 */
public class DeploymentsInner implements InnerSupportsGet<DeploymentExtendedInner>, InnerSupportsDelete<Void>, InnerSupportsListing<DeploymentExtendedInner> {
    /** The Retrofit service to perform REST calls. */
    private DeploymentsService service;
    /** The service client containing this operation class. */
    private ResourceManagementClientImpl client;

    /**
     * Initializes an instance of DeploymentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DeploymentsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = retrofit.create(DeploymentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Deployments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DeploymentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtScope" })
        @HTTP(path = "{scope}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtScope" })
        @HTTP(path = "{scope}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtScope" })
        @HEAD("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<Void>> checkExistenceAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtScope" })
        @PUT("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> createOrUpdateAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtScope" })
        @PUT("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtScope" })
        @GET("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> getAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtScope" })
        @POST("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        Observable<Response<ResponseBody>> cancelAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtScope" })
        @POST("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> validateAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtScope" })
        @POST("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> beginValidateAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtScope" })
        @POST("{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        Observable<Response<ResponseBody>> exportTemplateAtScope(@Path(value = "scope", encoded = true) String scope, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtScope" })
        @GET("{scope}/providers/Microsoft.Resources/deployments/")
        Observable<Response<ResponseBody>> listAtScope(@Path(value = "scope", encoded = true) String scope, @Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtTenantScope" })
        @HTTP(path = "providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtTenantScope" })
        @HTTP(path = "providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtTenantScope" })
        @HEAD("providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<Void>> checkExistenceAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtTenantScope" })
        @PUT("providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> createOrUpdateAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtTenantScope" })
        @PUT("providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtTenantScope" })
        @GET("providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> getAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        Observable<Response<ResponseBody>> cancelAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> validateAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> beginValidateAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> whatIfAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> beginWhatIfAtTenantScope(@Path("deploymentName") String deploymentName, @Body ScopedDeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtTenantScope" })
        @POST("providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        Observable<Response<ResponseBody>> exportTemplateAtTenantScope(@Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtTenantScope" })
        @GET("providers/Microsoft.Resources/deployments/")
        Observable<Response<ResponseBody>> listAtTenantScope(@Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtManagementGroupScope" })
        @HTTP(path = "providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtManagementGroupScope" })
        @HTTP(path = "providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtManagementGroupScope" })
        @HEAD("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<Void>> checkExistenceAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtManagementGroupScope" })
        @PUT("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> createOrUpdateAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtManagementGroupScope" })
        @PUT("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtManagementGroupScope" })
        @GET("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> getAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        Observable<Response<ResponseBody>> cancelAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> validateAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> beginValidateAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeployment parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> whatIfAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> beginWhatIfAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Body ScopedDeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtManagementGroupScope" })
        @POST("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        Observable<Response<ResponseBody>> exportTemplateAtManagementGroupScope(@Path("groupId") String groupId, @Path("deploymentName") String deploymentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtManagementGroupScope" })
        @GET("providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/")
        Observable<Response<ResponseBody>> listAtManagementGroupScope(@Path("groupId") String groupId, @Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtSubscriptionScope" })
        @HTTP(path = "subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtSubscriptionScope" })
        @HTTP(path = "subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDeleteAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtSubscriptionScope" })
        @HEAD("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<Void>> checkExistenceAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtSubscriptionScope" })
        @PUT("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> createOrUpdateAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtSubscriptionScope" })
        @PUT("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtSubscriptionScope" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> getAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        Observable<Response<ResponseBody>> cancelAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> validateAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> beginValidateAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> whatIfAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> beginWhatIfAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtSubscriptionScope" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        Observable<Response<ResponseBody>> exportTemplateAtSubscriptionScope(@Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistence" })
        @HEAD("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<Void>> checkExistence(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancel" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        Observable<Response<ResponseBody>> cancel(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validate" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> validate(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidate" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        Observable<Response<ResponseBody>> beginValidate(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIf" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> whatIf(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIf" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        Observable<Response<ResponseBody>> beginWhatIf(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Body DeploymentWhatIf parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplate" })
        @POST("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        Observable<Response<ResponseBody>> exportTemplate(@Path("resourceGroupName") String resourceGroupName, @Path("deploymentName") String deploymentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments calculateTemplateHash" })
        @POST("providers/Microsoft.Resources/calculateTemplateHash")
        Observable<Response<ResponseBody>> calculateTemplateHash(@Query("api-version") String apiVersion, @Body Object template, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtScopeNext" })
        @GET
        Observable<Response<ResponseBody>> listAtScopeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtTenantScopeNext" })
        @GET
        Observable<Response<ResponseBody>> listAtTenantScopeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtManagementGroupScopeNext" })
        @GET
        Observable<Response<ResponseBody>> listAtManagementGroupScopeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtScope(String scope, String deploymentName) {
        deleteAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().last().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtScopeAsync(String scope, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAtScopeAsync(String scope, String deploymentName) {
        return deleteAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteAtScope(String scope, String deploymentName) {
        beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAtScopeAsync(String scope, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAtScopeAsync(String scope, String deploymentName) {
        return beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkExistenceAtScope(String scope, String deploymentName) {
        return checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single().body();
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName) {
        return checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkExistenceAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkExistenceAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkExistenceAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkExistenceAtScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>() { }.getType());
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at a given scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = beginCreateOrUpdateAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .register(201, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner getAtScope(String scope, String deploymentName) {
        return getAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single().body();
    }

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName) {
        return getAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = getAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancelAtScope(String scope, String deploymentName) {
        cancelAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single().body();
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAtScopeAsync(String scope, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAtScopeAsync(String scope, String deploymentName) {
        return cancelAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancelAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.validateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>() { }.getType());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginValidateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentValidateResultInner> clientResponse = beginValidateAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentValidateResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExportResultInner object if successful.
     */
    public DeploymentExportResultInner exportTemplateAtScope(String scope, String deploymentName) {
        return exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single().body();
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName, final ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName) {
        return exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName).map(new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>() {
            @Override
            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.exportTemplateAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExportResultInner> clientResponse = exportTemplateAtScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExportResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExportResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtScope(final String scope) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtScopeSinglePageAsync(scope).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeAsync(final String scope, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtScopeSinglePageAsync(scope),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtScopeAsync(final String scope) {
        return listAtScopeWithServiceResponseAsync(scope)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeWithServiceResponseAsync(final String scope) {
        return listAtScopeSinglePageAsync(scope)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeSinglePageAsync(final String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        return service.listAtScope(scope, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtScope(final String scope, final String filter, final Integer top) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtScopeSinglePageAsync(scope, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeAsync(final String scope, final String filter, final Integer top, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtScopeSinglePageAsync(scope, filter, top),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtScopeAsync(final String scope, final String filter, final Integer top) {
        return listAtScopeWithServiceResponseAsync(scope, filter, top)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeWithServiceResponseAsync(final String scope, final String filter, final Integer top) {
        return listAtScopeSinglePageAsync(scope, filter, top)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param scope The resource scope.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeSinglePageAsync(final String scope, final String filter, final Integer top) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAtScope(scope, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtTenantScope(String deploymentName) {
        deleteAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().last().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtTenantScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAtTenantScopeAsync(String deploymentName) {
        return deleteAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteAtTenantScope(String deploymentName) {
        beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAtTenantScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAtTenantScopeAsync(String deploymentName) {
        return beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkExistenceAtTenantScope(String deploymentName) {
        return checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName) {
        return checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkExistenceAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkExistenceAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkExistenceAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkExistenceAtTenantScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>() { }.getType());
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at tenant scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = beginCreateOrUpdateAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .register(201, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner getAtTenantScope(String deploymentName) {
        return getAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName) {
        return getAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = getAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancelAtTenantScope(String deploymentName) {
        cancelAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAtTenantScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAtTenantScopeAsync(String deploymentName) {
        return cancelAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancelAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.validateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>() { }.getType());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginValidateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentValidateResultInner> clientResponse = beginValidateAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentValidateResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> whatIfAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.whatIfAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>() { }.getType(), DeploymentsWhatIfAtTenantScopeHeaders.class);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> beginWhatIfAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginWhatIfAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> clientResponse = beginWhatIfAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> beginWhatIfAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WhatIfOperationResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WhatIfOperationResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, DeploymentsWhatIfAtTenantScopeHeaders.class);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExportResultInner object if successful.
     */
    public DeploymentExportResultInner exportTemplateAtTenantScope(String deploymentName) {
        return exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName, final ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName) {
        return exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>() {
            @Override
            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.exportTemplateAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExportResultInner> clientResponse = exportTemplateAtTenantScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExportResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExportResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtTenantScope() {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtTenantScopeSinglePageAsync().toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeAsync(final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtTenantScopeSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtTenantScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeAsync() {
        return listAtTenantScopeWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeWithServiceResponseAsync() {
        return listAtTenantScopeSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        return service.listAtTenantScope(filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtTenantScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtTenantScope(final String filter, final Integer top) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtTenantScopeSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeAsync(final String filter, final Integer top, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtTenantScopeSinglePageAsync(filter, top),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtTenantScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeAsync(final String filter, final Integer top) {
        return listAtTenantScopeWithServiceResponseAsync(filter, top)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeWithServiceResponseAsync(final String filter, final Integer top) {
        return listAtTenantScopeSinglePageAsync(filter, top)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeSinglePageAsync(final String filter, final Integer top) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAtTenantScope(filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtTenantScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtManagementGroupScope(String groupId, String deploymentName) {
        deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().last().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteAtManagementGroupScope(String groupId, String deploymentName) {
        beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkExistenceAtManagementGroupScope(String groupId, String deploymentName) {
        return checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single().body();
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkExistenceAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkExistenceAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkExistenceAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkExistenceAtManagementGroupScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>() { }.getType());
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at management group scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = beginCreateOrUpdateAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .register(201, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner getAtManagementGroupScope(String groupId, String deploymentName) {
        return getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single().body();
    }

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = getAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancelAtManagementGroupScope(String groupId, String deploymentName) {
        cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single().body();
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancelAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.validateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>() { }.getType());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginValidateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentValidateResultInner> clientResponse = beginValidateAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentValidateResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> whatIfAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.whatIfAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>() { }.getType(), DeploymentsWhatIfAtManagementGroupScopeHeaders.class);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginWhatIfAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> clientResponse = beginWhatIfAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> beginWhatIfAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WhatIfOperationResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WhatIfOperationResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, DeploymentsWhatIfAtManagementGroupScopeHeaders.class);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExportResultInner object if successful.
     */
    public DeploymentExportResultInner exportTemplateAtManagementGroupScope(String groupId, String deploymentName) {
        return exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single().body();
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName, final ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map(new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>() {
            @Override
            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.exportTemplateAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExportResultInner> clientResponse = exportTemplateAtManagementGroupScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExportResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExportResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtManagementGroupScope(final String groupId) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtManagementGroupScopeSinglePageAsync(groupId).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(final String groupId, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtManagementGroupScopeSinglePageAsync(groupId),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(final String groupId) {
        return listAtManagementGroupScopeWithServiceResponseAsync(groupId)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeWithServiceResponseAsync(final String groupId) {
        return listAtManagementGroupScopeSinglePageAsync(groupId)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeSinglePageAsync(final String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        return service.listAtManagementGroupScope(groupId, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtManagementGroupScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtManagementGroupScope(final String groupId, final String filter, final Integer top) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtManagementGroupScopeSinglePageAsync(groupId, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(final String groupId, final String filter, final Integer top, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtManagementGroupScopeSinglePageAsync(groupId, filter, top),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(final String groupId, final String filter, final Integer top) {
        return listAtManagementGroupScopeWithServiceResponseAsync(groupId, filter, top)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeWithServiceResponseAsync(final String groupId, final String filter, final Integer top) {
        return listAtManagementGroupScopeSinglePageAsync(groupId, filter, top)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param groupId The management group ID.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeSinglePageAsync(final String groupId, final String filter, final Integer top) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAtManagementGroupScope(groupId, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtManagementGroupScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtSubscriptionScope(String deploymentName) {
        deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().last().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAtSubscriptionScopeAsync(String deploymentName) {
        return deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.deleteAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDeleteAtSubscriptionScope(String deploymentName) {
        beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName) {
        return beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDeleteAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkExistenceAtSubscriptionScope(String deploymentName) {
        return checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName) {
        return checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkExistenceAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkExistenceAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkExistenceAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkExistenceAtSubscriptionScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>() { }.getType());
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources at subscription scope.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = beginCreateOrUpdateAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .register(201, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner getAtSubscriptionScope(String deploymentName) {
        return getAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName) {
        return getAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = getAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancelAtSubscriptionScope(String deploymentName) {
        cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAtSubscriptionScopeAsync(String deploymentName) {
        return cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resources partially deployed.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancelAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.validateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>() { }.getType());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginValidateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentValidateResultInner> clientResponse = beginValidateAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentValidateResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        return whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> whatIfAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.whatIfAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>() { }.getType(), DeploymentsWhatIfAtSubscriptionScopeHeaders.class);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        return beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     *
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginWhatIfAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> clientResponse = beginWhatIfAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> beginWhatIfAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WhatIfOperationResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WhatIfOperationResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, DeploymentsWhatIfAtSubscriptionScopeHeaders.class);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExportResultInner object if successful.
     */
    public DeploymentExportResultInner exportTemplateAtSubscriptionScope(String deploymentName) {
        return exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single().body();
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName, final ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName) {
        return exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map(new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>() {
            @Override
            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.exportTemplateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExportResultInner> clientResponse = exportTemplateAtSubscriptionScopeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExportResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExportResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> list() {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAsync(final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        return service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> list(final String filter, final Integer top) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAsync(final String filter, final Integer top, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(filter, top),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAsync(final String filter, final Integer top) {
        return listWithServiceResponseAsync(filter, top)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listWithServiceResponseAsync(final String filter, final Integer top) {
        return listSinglePageAsync(filter, top)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listSinglePageAsync(final String filter, final Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String deploymentName) {
        deleteWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().last().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String deploymentName) {
        return deleteWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String deploymentName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single().body();
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String deploymentName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a deployment from the deployment history.
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the associated deployment operations. Deleting a template deployment does not affect the state of the resource group. This is an asynchronous operation that returns a status of 202 until the template deployment is successfully deleted. The Location response header contains the URI that is used to obtain the status of the process. While the process is running, a call to the URI in the Location header returns a status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed, the URI in the Location header returns an error-level status code.
     *
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the boolean object if successful.
     */
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single().body();
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName, final ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName) {
        return checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<Boolean>, Boolean>() {
            @Override
            public Boolean call(ServiceResponse<Boolean> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the deployment exists.
     *
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Boolean object
     */
    public Observable<ServiceResponse<Boolean>> checkExistenceWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.checkExistence(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>() {
                @Override
                public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                    try {
                        ServiceResponse<Boolean> clientResponse = checkExistenceDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Boolean> checkExistenceDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Boolean, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildEmpty(response);
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>() { }.getType());
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner beginCreateOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deploys resources to a resource group.
     * You can provide the template and parameters directly in the request or link to JSON files.
     *
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive. The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .register(201, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExtendedInner object if successful.
     */
    public DeploymentExtendedInner getByResourceGroup(String resourceGroupName, String deploymentName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single().body();
    }

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName, final ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>() {
            @Override
            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExtendedInner object
     */
    public Observable<ServiceResponse<DeploymentExtendedInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExtendedInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExtendedInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExtendedInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExtendedInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancel(String resourceGroupName, String deploymentName) {
        cancelWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single().body();
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String deploymentName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> cancelAsync(String resourceGroupName, String deploymentName) {
        return cancelWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a currently running template deployment.
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running template deployment and leaves the resource group partially deployed.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancel(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = cancelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> cancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.validate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>() { }.getType());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentValidateResultInner object if successful.
     */
    public DeploymentValidateResultInner beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, final ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>() {
            @Override
            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource Manager..
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentValidateResultInner object
     */
    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginValidate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentValidateResultInner> clientResponse = beginValidateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentValidateResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<DeploymentValidateResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> whatIfWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.whatIf(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>() { }.getType(), DeploymentsWhatIfHeaders.class);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WhatIfOperationResultInner object if successful.
     */
    public WhatIfOperationResultInner beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single().body();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, final ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map(new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>, WhatIfOperationResultInner>() {
            @Override
            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     *
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WhatIfOperationResultInner object
     */
    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> beginWhatIfWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginWhatIf(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> clientResponse = beginWhatIfDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> beginWhatIfDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WhatIfOperationResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WhatIfOperationResultInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, DeploymentsWhatIfHeaders.class);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentExportResultInner object if successful.
     */
    public DeploymentExportResultInner exportTemplate(String resourceGroupName, String deploymentName) {
        return exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single().body();
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName, final ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName) {
        return exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName).map(new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>() {
            @Override
            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Exports the template used for specified deployment.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentExportResultInner object
     */
    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.exportTemplate(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentExportResultInner> clientResponse = exportTemplateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentExportResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentExportResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        final Integer top = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listByResourceGroup(final String resourceGroupName, final String filter, final Integer top) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter, final Integer top, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, filter, top),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupAsync(final String resourceGroupName, final String filter, final Integer top) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter, top)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final String filter, final Integer top) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, filter, top)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param resourceGroupName The name of the resource group with the deployments to get. The name is case insensitive.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final String filter, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TemplateHashResultInner object if successful.
     */
    public TemplateHashResultInner calculateTemplateHash(Object template) {
        return calculateTemplateHashWithServiceResponseAsync(template).toBlocking().single().body();
    }

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TemplateHashResultInner> calculateTemplateHashAsync(Object template, final ServiceCallback<TemplateHashResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(calculateTemplateHashWithServiceResponseAsync(template), serviceCallback);
    }

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TemplateHashResultInner object
     */
    public Observable<TemplateHashResultInner> calculateTemplateHashAsync(Object template) {
        return calculateTemplateHashWithServiceResponseAsync(template).map(new Func1<ServiceResponse<TemplateHashResultInner>, TemplateHashResultInner>() {
            @Override
            public TemplateHashResultInner call(ServiceResponse<TemplateHashResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Calculate the hash of the given template.
     *
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TemplateHashResultInner object
     */
    public Observable<ServiceResponse<TemplateHashResultInner>> calculateTemplateHashWithServiceResponseAsync(Object template) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (template == null) {
            throw new IllegalArgumentException("Parameter template is required and cannot be null.");
        }
        return service.calculateTemplateHash(this.client.apiVersion(), template, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TemplateHashResultInner>>>() {
                @Override
                public Observable<ServiceResponse<TemplateHashResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TemplateHashResultInner> clientResponse = calculateTemplateHashDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TemplateHashResultInner> calculateTemplateHashDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TemplateHashResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TemplateHashResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtScopeNext(final String nextPageLink) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeNextAsync(final String nextPageLink, final ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtScopeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtScopeNextAsync(final String nextPageLink) {
        return listAtScopeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeNextWithServiceResponseAsync(final String nextPageLink) {
        return listAtScopeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the given scope.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAtScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtScopeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtTenantScopeNext(final String nextPageLink) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeNextAsync(final String nextPageLink, final ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtTenantScopeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtTenantScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeNextAsync(final String nextPageLink) {
        return listAtTenantScopeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeNextWithServiceResponseAsync(final String nextPageLink) {
        return listAtTenantScopeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments at the tenant scope.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAtTenantScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtTenantScopeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtTenantScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listAtManagementGroupScopeNext(final String nextPageLink) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeNextAsync(final String nextPageLink, final ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAtManagementGroupScopeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeNextAsync(final String nextPageLink) {
        return listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeNextWithServiceResponseAsync(final String nextPageLink) {
        return listAtManagementGroupScopeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a management group.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAtManagementGroupScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listAtManagementGroupScopeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtManagementGroupScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a subscription.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object if successful.
     */
    public PagedList<DeploymentExtendedInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<DeploymentExtendedInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>(response.body()) {
            @Override
            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, final ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>() {
                @Override
                public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentExtendedInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all the deployments for a resource group.
     *
    ServiceResponse<PageImpl<DeploymentExtendedInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentExtendedInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentExtendedInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentExtendedInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentExtendedInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
