/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for TagOperation.
 */
public final class TagOperation extends ExpandableStringEnum<TagOperation> {
    /** Static value Replace for TagOperation. */
    public static final TagOperation REPLACE = fromString("Replace");

    /** Static value Merge for TagOperation. */
    public static final TagOperation MERGE = fromString("Merge");

    /** Static value Delete for TagOperation. */
    public static final TagOperation DELETE = fromString("Delete");

    /**
     * Creates or finds a TagOperation from its string representation.
     * @param name a name to look for
     * @return the corresponding TagOperation
     */
    @JsonCreator
    public static TagOperation fromString(String name) {
        return fromString(name, TagOperation.class);
    }

    /**
     * @return known TagOperation values
     */
    public static Collection<TagOperation> values() {
        return values(TagOperation.class);
    }
}
