/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The resource management error response.
 */
public class ErrorResponse {
    /**
     * The error code.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private String code;

    /**
     * The error message.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * The error target.
     */
    @JsonProperty(value = "target", access = JsonProperty.Access.WRITE_ONLY)
    private String target;

    /**
     * The error details.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private List<ErrorResponse> details;

    /**
     * The error additional info.
     */
    @JsonProperty(value = "additionalInfo", access = JsonProperty.Access.WRITE_ONLY)
    private List<ErrorAdditionalInfo> additionalInfo;

    /**
     * Get the error code.
     *
     * @return the code value
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error message.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the error target.
     *
     * @return the target value
     */
    public String target() {
        return this.target;
    }

    /**
     * Get the error details.
     *
     * @return the details value
     */
    public List<ErrorResponse> details() {
        return this.details;
    }

    /**
     * Get the error additional info.
     *
     * @return the additionalInfo value
     */
    public List<ErrorAdditionalInfo> additionalInfo() {
        return this.additionalInfo;
    }

}
