/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.ExportTemplateRequest;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.ResourceGroupExportResult;
import com.microsoft.azure.management.resources.ResourceGroupExportTemplateOptions;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

class ResourceGroupImpl
extends CreatableUpdatableImpl<ResourceGroup, ResourceGroupInner, ResourceGroupImpl>
implements ResourceGroup,
ResourceGroup.Definition,
ResourceGroup.Update {
    private final ResourceGroupsInner client;

    protected ResourceGroupImpl(ResourceGroupInner innerModel, String name, ResourceManagementClientImpl serviceClient) {
        super(name, innerModel);
        this.client = serviceClient.resourceGroups();
    }

    @Override
    public String provisioningState() {
        return ((ResourceGroupInner)((Object)this.inner())).properties().provisioningState();
    }

    @Override
    public String regionName() {
        return ((ResourceGroupInner)((Object)this.inner())).location();
    }

    @Override
    public Region region() {
        return Region.fromName(this.regionName());
    }

    @Override
    public String id() {
        return ((ResourceGroupInner)((Object)this.inner())).id();
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Map<String, String> tags() {
        HashMap tags = ((ResourceGroupInner)((Object)this.inner())).getTags();
        if (tags == null) {
            tags = new HashMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public ResourceGroupExportResult exportTemplate(ResourceGroupExportTemplateOptions options) {
        return (ResourceGroupExportResult)this.exportTemplateAsync(options).toBlocking().last();
    }

    @Override
    public Observable<ResourceGroupExportResult> exportTemplateAsync(ResourceGroupExportTemplateOptions options) {
        ExportTemplateRequest inner = new ExportTemplateRequest().withResources(Arrays.asList("*")).withOptions(options.toString());
        return this.client.exportTemplateAsync(this.name(), inner).map((Func1)new Func1<ResourceGroupExportResultInner, ResourceGroupExportResult>(){

            public ResourceGroupExportResult call(ResourceGroupExportResultInner resourceGroupExportResultInner) {
                return new ResourceGroupExportResultImpl(resourceGroupExportResultInner);
            }
        });
    }

    @Override
    public ServiceFuture<ResourceGroupExportResult> exportTemplateAsync(ResourceGroupExportTemplateOptions options, ServiceCallback<ResourceGroupExportResult> callback) {
        return ServiceFuture.fromBody(this.exportTemplateAsync(options), callback);
    }

    @Override
    public ResourceGroupImpl withRegion(String regionName) {
        ((ResourceGroupInner)((Object)this.inner())).withLocation(regionName);
        return this;
    }

    @Override
    public ResourceGroupImpl withRegion(Region region) {
        return this.withRegion(region.toString());
    }

    @Override
    public ResourceGroupImpl withTags(Map<String, String> tags) {
        ((ResourceGroupInner)((Object)this.inner())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public ResourceGroupImpl withTag(String key, String value) {
        if (((ResourceGroupInner)((Object)this.inner())).getTags() == null) {
            ((ResourceGroupInner)((Object)this.inner())).withTags(new HashMap());
        }
        ((ResourceGroupInner)((Object)this.inner())).getTags().put(key, value);
        return this;
    }

    @Override
    public ResourceGroupImpl withoutTag(String key) {
        ((ResourceGroupInner)((Object)this.inner())).getTags().remove(key);
        return this;
    }

    @Override
    public Observable<ResourceGroup> createResourceAsync() {
        ResourceGroupInner params = new ResourceGroupInner();
        params.withLocation(((ResourceGroupInner)((Object)this.inner())).location());
        params.withTags(((ResourceGroupInner)((Object)this.inner())).getTags());
        return this.client.createOrUpdateAsync(this.name(), params).map(this.innerToFluentMap(this));
    }

    @Override
    public Observable<ResourceGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public boolean isInCreateMode() {
        return ((ResourceGroupInner)((Object)this.inner())).id() == null;
    }

    @Override
    protected Observable<ResourceGroupInner> getInnerAsync() {
        return this.client.getAsync(this.key);
    }
}

