/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.Plan;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.resources.implementation.ResourcesInner;
import rx.Observable;
import rx.functions.Func1;

final class GenericResourceImpl
extends GroupableResourceImpl<GenericResource, GenericResourceInner, GenericResourceImpl, ResourceManager>
implements GenericResource,
GenericResource.Definition,
GenericResource.UpdateStages.WithApiVersion,
GenericResource.Update {
    private String resourceProviderNamespace;
    private String parentResourcePath;
    private String resourceType;
    private String apiVersion;

    GenericResourceImpl(String key, GenericResourceInner innerModel, ResourceManager resourceManager) {
        super(key, innerModel, resourceManager);
        this.resourceProviderNamespace = ResourceUtils.resourceProviderFromResourceId(innerModel.id());
        this.resourceType = ResourceUtils.resourceTypeFromResourceId(innerModel.id());
        this.parentResourcePath = ResourceUtils.parentRelativePathFromResourceId(innerModel.id());
    }

    @Override
    public String resourceProviderNamespace() {
        return this.resourceProviderNamespace;
    }

    @Override
    public String parentResourcePath() {
        if (this.parentResourcePath == null) {
            return "";
        }
        return this.parentResourcePath;
    }

    @Override
    public String resourceType() {
        return this.resourceType;
    }

    @Override
    public String apiVersion() {
        if (this.apiVersion == null) {
            this.apiVersion = ResourceUtils.defaultApiVersion(this.id(), (Provider)((ResourceManager)this.manager()).providers().getByName(ResourceUtils.resourceProviderFromResourceId(this.id())));
        }
        return this.apiVersion;
    }

    @Override
    public Plan plan() {
        return ((GenericResourceInner)((Object)this.inner())).plan();
    }

    @Override
    public Object properties() {
        return ((GenericResourceInner)((Object)this.inner())).properties();
    }

    @Override
    protected Observable<GenericResourceInner> getInnerAsync() {
        return ((ResourceManager)this.manager()).inner().resources().getAsync(this.resourceGroupName(), this.resourceProviderNamespace(), this.parentResourcePath(), this.resourceType(), this.name(), this.apiVersion());
    }

    @Override
    public GenericResourceImpl withProperties(Object properties) {
        ((GenericResourceInner)((Object)this.inner())).withProperties(properties);
        return this;
    }

    @Override
    public GenericResourceImpl withParentResourceId(String parentResourceId) {
        return this.withParentResourcePath(ResourceUtils.relativePathFromResourceId(parentResourceId));
    }

    @Override
    public GenericResourceImpl withParentResourcePath(String parentResourcePath) {
        this.parentResourcePath = parentResourcePath;
        return this;
    }

    @Override
    public GenericResourceImpl withPlan(String name, String publisher, String product, String promotionCode) {
        ((GenericResourceInner)((Object)this.inner())).withPlan(new Plan().withName(name).withPublisher(publisher).withProduct(product).withPromotionCode(promotionCode));
        return this;
    }

    @Override
    public GenericResourceImpl withoutPlan() {
        ((GenericResourceInner)((Object)this.inner())).withPlan(null);
        return this;
    }

    @Override
    public GenericResourceImpl withProviderNamespace(String resourceProviderNamespace) {
        this.resourceProviderNamespace = resourceProviderNamespace;
        return this;
    }

    @Override
    public GenericResourceImpl withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public GenericResourceImpl withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public Observable<GenericResource> createResourceAsync() {
        final GenericResourceImpl self = this;
        Observable observable = Observable.just((Object)this.apiVersion);
        if (this.apiVersion == null) {
            final ResourceManagementClientImpl serviceClient = ((ResourceManager)this.manager()).inner();
            observable = ((ResourceManager)this.manager()).providers().getByNameAsync(this.resourceProviderNamespace).map((Func1)new Func1<Provider, String>(){

                public String call(Provider provider) {
                    String id = !GenericResourceImpl.this.isInCreateMode() ? ((GenericResourceInner)((Object)GenericResourceImpl.this.inner())).id() : ResourceUtils.constructResourceId(serviceClient.subscriptionId(), GenericResourceImpl.this.resourceGroupName(), GenericResourceImpl.this.resourceProviderNamespace(), GenericResourceImpl.this.resourceType(), GenericResourceImpl.this.name(), GenericResourceImpl.this.parentResourcePath());
                    self.apiVersion = ResourceUtils.defaultApiVersion(id, provider);
                    return self.apiVersion;
                }
            });
        }
        final ResourcesInner resourceClient = ((ResourceManager)this.manager()).inner().resources();
        return observable.flatMap((Func1)new Func1<String, Observable<GenericResource>>(){

            public Observable<GenericResource> call(String api) {
                String name = GenericResourceImpl.this.name();
                if (!GenericResourceImpl.this.isInCreateMode()) {
                    name = ResourceUtils.nameFromResourceId(((GenericResourceInner)((Object)GenericResourceImpl.this.inner())).id());
                }
                return resourceClient.createOrUpdateAsync(GenericResourceImpl.this.resourceGroupName(), GenericResourceImpl.this.resourceProviderNamespace, GenericResourceImpl.this.parentResourcePath(), GenericResourceImpl.this.resourceType, name, api, (GenericResourceInner)((Object)GenericResourceImpl.this.inner())).subscribeOn(SdkContext.getRxScheduler()).map(GenericResourceImpl.this.innerToFluentMap(self));
            }
        });
    }
}

