/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PolicyType.
 */
public final class PolicyType {
    /** Static value NotSpecified for PolicyType. */
    public static final PolicyType NOT_SPECIFIED = new PolicyType("NotSpecified");

    /** Static value BuiltIn for PolicyType. */
    public static final PolicyType BUILT_IN = new PolicyType("BuiltIn");

    /** Static value Custom for PolicyType. */
    public static final PolicyType CUSTOM = new PolicyType("Custom");

    private String value;

    /**
     * Creates a custom value for PolicyType.
     * @param value the custom value
     */
    public PolicyType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PolicyType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PolicyType rhs = (PolicyType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
