/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.redis.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.redis.RedisLinkedServerCreateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in LinkedServers.
 */
public class LinkedServersInner {
    /** The Retrofit service to perform REST calls. */
    private LinkedServersService service;
    /** The service client containing this operation class. */
    private RedisManagementClientImpl client;

    /**
     * Initializes an instance of LinkedServersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public LinkedServersInner(Retrofit retrofit, RedisManagementClientImpl client) {
        this.service = retrofit.create(LinkedServersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for LinkedServers to be
     * used by Retrofit to perform actually REST calls.
     */
    interface LinkedServersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("linkedServerName") String linkedServerName, @Path("subscriptionId") String subscriptionId, @Body RedisLinkedServerCreateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("linkedServerName") String linkedServerName, @Path("subscriptionId") String subscriptionId, @Body RedisLinkedServerCreateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("linkedServerName") String linkedServerName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("linkedServerName") String linkedServerName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RedisLinkedServerWithPropertiesInner object if successful.
     */
    public RedisLinkedServerWithPropertiesInner create(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).toBlocking().last().body();
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, final ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters), serviceCallback);
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).map(new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>() {
            @Override
            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> createWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RedisLinkedServerWithPropertiesInner>() { }.getType());
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RedisLinkedServerWithPropertiesInner object if successful.
     */
    public RedisLinkedServerWithPropertiesInner beginCreate(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).toBlocking().single().body();
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, final ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters), serviceCallback);
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RedisLinkedServerWithPropertiesInner object
     */
    public Observable<RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).map(new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>() {
            @Override
            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Adds a linked server to the Redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param parameters Parameters supplied to the Create Linked server operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RedisLinkedServerWithPropertiesInner object
     */
    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreate(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>>>() {
                @Override
                public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RedisLinkedServerWithPropertiesInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RedisLinkedServerWithPropertiesInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RedisLinkedServerWithPropertiesInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RedisLinkedServerWithPropertiesInner>() { }.getType())
                .register(201, new TypeToken<RedisLinkedServerWithPropertiesInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes the linked server from a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String name, String linkedServerName) {
        deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName).toBlocking().single().body();
    }

    /**
     * Deletes the linked server from a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, String linkedServerName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName), serviceCallback);
    }

    /**
     * Deletes the linked server from a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String name, String linkedServerName) {
        return deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the linked server from a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server that is being added to the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the detailed information about a linked server of a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RedisLinkedServerWithPropertiesInner object if successful.
     */
    public RedisLinkedServerWithPropertiesInner get(String resourceGroupName, String name, String linkedServerName) {
        return getWithServiceResponseAsync(resourceGroupName, name, linkedServerName).toBlocking().single().body();
    }

    /**
     * Gets the detailed information about a linked server of a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RedisLinkedServerWithPropertiesInner> getAsync(String resourceGroupName, String name, String linkedServerName, final ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, name, linkedServerName), serviceCallback);
    }

    /**
     * Gets the detailed information about a linked server of a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RedisLinkedServerWithPropertiesInner object
     */
    public Observable<RedisLinkedServerWithPropertiesInner> getAsync(String resourceGroupName, String name, String linkedServerName) {
        return getWithServiceResponseAsync(resourceGroupName, name, linkedServerName).map(new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>() {
            @Override
            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the detailed information about a linked server of a redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param linkedServerName The name of the linked server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RedisLinkedServerWithPropertiesInner object
     */
    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> getWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>>>() {
                @Override
                public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RedisLinkedServerWithPropertiesInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RedisLinkedServerWithPropertiesInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RedisLinkedServerWithPropertiesInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RedisLinkedServerWithPropertiesInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object if successful.
     */
    public PagedList<RedisLinkedServerWithPropertiesInner> list(final String resourceGroupName, final String name) {
        ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response = listSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<RedisLinkedServerWithPropertiesInner>(response.body()) {
            @Override
            public Page<RedisLinkedServerWithPropertiesInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> listAsync(final String resourceGroupName, final String name, final ListOperationCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object
     */
    public Observable<Page<RedisLinkedServerWithPropertiesInner>> listAsync(final String resourceGroupName, final String name) {
        return listWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Page<RedisLinkedServerWithPropertiesInner>>() {
                @Override
                public Page<RedisLinkedServerWithPropertiesInner> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object
     */
    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
    ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> * @param name The name of the redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RedisLinkedServerWithPropertiesInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RedisLinkedServerWithPropertiesInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object if successful.
     */
    public PagedList<RedisLinkedServerWithPropertiesInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisLinkedServerWithPropertiesInner>(response.body()) {
            @Override
            public Page<RedisLinkedServerWithPropertiesInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> serviceFuture, final ListOperationCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object
     */
    public Observable<Page<RedisLinkedServerWithPropertiesInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Page<RedisLinkedServerWithPropertiesInner>>() {
                @Override
                public Page<RedisLinkedServerWithPropertiesInner> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object
     */
    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the list of linked servers associated with this redis cache (requires Premium SKU).
     *
    ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RedisLinkedServerWithPropertiesInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RedisLinkedServerWithPropertiesInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RedisLinkedServerWithPropertiesInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
