/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.network.GetVpnSitesConfigurationRequest;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VpnSitesConfigurationsInner {
    private VpnSitesConfigurationsService service;
    private NetworkManagementClientImpl client;

    public VpnSitesConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnSitesConfigurationsService)retrofit.create(VpnSitesConfigurationsService.class);
        this.client = client;
    }

    public void download(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        ((ServiceResponse)this.downloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request).toBlocking().last()).body();
    }

    public ServiceFuture<Void> downloadAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.downloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request), serviceCallback);
    }

    public Observable<Void> downloadAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        return this.downloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> downloadWithServiceResponseAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        Validator.validate((Object)request);
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.download(this.client.subscriptionId(), resourceGroupName, virtualWANName, request, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginDownload(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        ((ServiceResponse)this.beginDownloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDownloadAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDownloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request), serviceCallback);
    }

    public Observable<Void> beginDownloadAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        return this.beginDownloadWithServiceResponseAsync(resourceGroupName, virtualWANName, request).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDownloadWithServiceResponseAsync(String resourceGroupName, String virtualWANName, GetVpnSitesConfigurationRequest request) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        Validator.validate((Object)request);
        String apiVersion = "2019-11-01";
        return this.service.beginDownload(this.client.subscriptionId(), resourceGroupName, virtualWANName, request, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesConfigurationsInner.this.beginDownloadDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDownloadDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VpnSitesConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSitesConfigurations download"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnConfiguration")
        public Observable<Response<ResponseBody>> download(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Body GetVpnSitesConfigurationRequest var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSitesConfigurations beginDownload"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnConfiguration")
        public Observable<Response<ResponseBody>> beginDownload(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Body GetVpnSitesConfigurationRequest var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

