/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceTapConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NetworkInterfaceTapConfigurationsInner {
    private NetworkInterfaceTapConfigurationsService service;
    private NetworkManagementClientImpl client;

    public NetworkInterfaceTapConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (NetworkInterfaceTapConfigurationsService)retrofit.create(NetworkInterfaceTapConfigurationsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (tapConfigurationName == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkInterfaceName, tapConfigurationName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (tapConfigurationName == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, networkInterfaceName, tapConfigurationName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkInterfaceTapConfigurationsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkInterfaceTapConfigurationInner get(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        return (NetworkInterfaceTapConfigurationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkInterfaceTapConfigurationInner> getAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, ServiceCallback<NetworkInterfaceTapConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName), serviceCallback);
    }

    public Observable<NetworkInterfaceTapConfigurationInner> getAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName).map((Func1)new Func1<ServiceResponse<NetworkInterfaceTapConfigurationInner>, NetworkInterfaceTapConfigurationInner>(){

            public NetworkInterfaceTapConfigurationInner call(ServiceResponse<NetworkInterfaceTapConfigurationInner> response) {
                return (NetworkInterfaceTapConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (tapConfigurationName == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, networkInterfaceName, tapConfigurationName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>>>(){

            public Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkInterfaceTapConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkInterfaceTapConfigurationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkInterfaceTapConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkInterfaceTapConfigurationInner createOrUpdate(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        return (NetworkInterfaceTapConfigurationInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters).toBlocking().last()).body());
    }

    public ServiceFuture<NetworkInterfaceTapConfigurationInner> createOrUpdateAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters, ServiceCallback<NetworkInterfaceTapConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters), serviceCallback);
    }

    public Observable<NetworkInterfaceTapConfigurationInner> createOrUpdateAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters).map((Func1)new Func1<ServiceResponse<NetworkInterfaceTapConfigurationInner>, NetworkInterfaceTapConfigurationInner>(){

            public NetworkInterfaceTapConfigurationInner call(ServiceResponse<NetworkInterfaceTapConfigurationInner> response) {
                return (NetworkInterfaceTapConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (tapConfigurationName == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (tapConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)tapConfigurationParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, networkInterfaceName, tapConfigurationName, this.client.subscriptionId(), tapConfigurationParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NetworkInterfaceTapConfigurationInner>(){}.getType());
    }

    public NetworkInterfaceTapConfigurationInner beginCreateOrUpdate(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        return (NetworkInterfaceTapConfigurationInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkInterfaceTapConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters, ServiceCallback<NetworkInterfaceTapConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters), serviceCallback);
    }

    public Observable<NetworkInterfaceTapConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, networkInterfaceName, tapConfigurationName, tapConfigurationParameters).map((Func1)new Func1<ServiceResponse<NetworkInterfaceTapConfigurationInner>, NetworkInterfaceTapConfigurationInner>(){

            public NetworkInterfaceTapConfigurationInner call(ServiceResponse<NetworkInterfaceTapConfigurationInner> response) {
                return (NetworkInterfaceTapConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName, String tapConfigurationName, NetworkInterfaceTapConfigurationInner tapConfigurationParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (tapConfigurationName == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (tapConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter tapConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)tapConfigurationParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, networkInterfaceName, tapConfigurationName, this.client.subscriptionId(), tapConfigurationParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>>>(){

            public Observable<ServiceResponse<NetworkInterfaceTapConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkInterfaceTapConfigurationsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkInterfaceTapConfigurationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkInterfaceTapConfigurationInner>(){}.getType()).register(201, new TypeToken<NetworkInterfaceTapConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkInterfaceTapConfigurationInner> list(String resourceGroupName, String networkInterfaceName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, networkInterfaceName).toBlocking().single();
        return new PagedList<NetworkInterfaceTapConfigurationInner>((Page)response.body()){

            public Page<NetworkInterfaceTapConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkInterfaceTapConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkInterfaceTapConfigurationInner>> listAsync(String resourceGroupName, String networkInterfaceName, ListOperationCallback<NetworkInterfaceTapConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, networkInterfaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(String nextPageLink) {
                return NetworkInterfaceTapConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkInterfaceTapConfigurationInner>> listAsync(String resourceGroupName, String networkInterfaceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, networkInterfaceName).map((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>, Page<NetworkInterfaceTapConfigurationInner>>(){

            public Page<NetworkInterfaceTapConfigurationInner> call(ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkInterfaceName) {
        return this.listSinglePageAsync(resourceGroupName, networkInterfaceName).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkInterfaceTapConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> listSinglePageAsync(String resourceGroupName, String networkInterfaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkInterfaceName == null) {
            throw new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, networkInterfaceName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkInterfaceTapConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkInterfaceTapConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkInterfaceTapConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkInterfaceTapConfigurationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NetworkInterfaceTapConfigurationInner>((Page)response.body()){

            public Page<NetworkInterfaceTapConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkInterfaceTapConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkInterfaceTapConfigurationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<NetworkInterfaceTapConfigurationInner>> serviceFuture, ListOperationCallback<NetworkInterfaceTapConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(String nextPageLink) {
                return NetworkInterfaceTapConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkInterfaceTapConfigurationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>, Page<NetworkInterfaceTapConfigurationInner>>(){

            public Page<NetworkInterfaceTapConfigurationInner> call(ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkInterfaceTapConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkInterfaceTapConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkInterfaceTapConfigurationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkInterfaceTapConfigurationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkInterfaceTapConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkInterfaceTapConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="tapConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="tapConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="tapConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="tapConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Body NetworkInterfaceTapConfigurationInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="tapConfigurationName") String var3, @Path(value="subscriptionId") String var4, @Body NetworkInterfaceTapConfigurationInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="networkInterfaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkInterfaceTapConfigurations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

