/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.OutboundRuleInner;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancerOutboundRulesInner {
    private LoadBalancerOutboundRulesService service;
    private NetworkManagementClientImpl client;

    public LoadBalancerOutboundRulesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancerOutboundRulesService)retrofit.create(LoadBalancerOutboundRulesService.class);
        this.client = client;
    }

    public PagedList<OutboundRuleInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<OutboundRuleInner>((Page)response.body()){

            public Page<OutboundRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerOutboundRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OutboundRuleInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<OutboundRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(String nextPageLink) {
                return LoadBalancerOutboundRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OutboundRuleInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<OutboundRuleInner>>, Page<OutboundRuleInner>>(){

            public Page<OutboundRuleInner> call(ServiceResponse<Page<OutboundRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OutboundRuleInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<OutboundRuleInner>>, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(ServiceResponse<Page<OutboundRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerOutboundRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OutboundRuleInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerOutboundRulesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OutboundRuleInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OutboundRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OutboundRuleInner get(String resourceGroupName, String loadBalancerName, String outboundRuleName) {
        return (OutboundRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, outboundRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<OutboundRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String outboundRuleName, ServiceCallback<OutboundRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, outboundRuleName), serviceCallback);
    }

    public Observable<OutboundRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String outboundRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, outboundRuleName).map((Func1)new Func1<ServiceResponse<OutboundRuleInner>, OutboundRuleInner>(){

            public OutboundRuleInner call(ServiceResponse<OutboundRuleInner> response) {
                return (OutboundRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OutboundRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String outboundRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (outboundRuleName == null) {
            throw new IllegalArgumentException("Parameter outboundRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, loadBalancerName, outboundRuleName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OutboundRuleInner>>>(){

            public Observable<ServiceResponse<OutboundRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancerOutboundRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OutboundRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OutboundRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<OutboundRuleInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OutboundRuleInner>((Page)response.body()){

            public Page<OutboundRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerOutboundRulesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OutboundRuleInner>> listNextAsync(String nextPageLink, ServiceFuture<List<OutboundRuleInner>> serviceFuture, ListOperationCallback<OutboundRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(String nextPageLink) {
                return LoadBalancerOutboundRulesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OutboundRuleInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OutboundRuleInner>>, Page<OutboundRuleInner>>(){

            public Page<OutboundRuleInner> call(ServiceResponse<Page<OutboundRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OutboundRuleInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OutboundRuleInner>>, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(ServiceResponse<Page<OutboundRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerOutboundRulesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OutboundRuleInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OutboundRuleInner>>>>(){

            public Observable<ServiceResponse<Page<OutboundRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerOutboundRulesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OutboundRuleInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OutboundRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancerOutboundRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerOutboundRules list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/outboundRules")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerOutboundRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/outboundRules/{outboundRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="outboundRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerOutboundRules listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

