/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.network.ExpressRouteCircuitReference;
import com.microsoft.azure.management.network.ExpressRouteCrossConnection;
import com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeering;
import com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeerings;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.ServiceProviderProvisioningState;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringsImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.model.GroupableParentResourceWithTagsImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteCrossConnectionImpl
extends GroupableParentResourceWithTagsImpl<ExpressRouteCrossConnection, ExpressRouteCrossConnectionInner, ExpressRouteCrossConnectionImpl, NetworkManager>
implements ExpressRouteCrossConnection,
ExpressRouteCrossConnection.Update {
    private ExpressRouteCrossConnectionPeeringsImpl peerings;
    private Map<String, ExpressRouteCrossConnectionPeering> crossConnectionPeerings;

    ExpressRouteCrossConnectionImpl(String name, ExpressRouteCrossConnectionInner innerObject, NetworkManager manager) {
        super(name, innerObject, manager);
        this.initializeChildrenFromInner();
    }

    protected void beforeCreating() {
    }

    protected void afterCreating() {
    }

    protected Observable<ExpressRouteCrossConnectionInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCrossConnections().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ExpressRouteCrossConnectionInner)((Object)this.inner()));
    }

    protected void initializeChildrenFromInner() {
        this.crossConnectionPeerings = new HashMap<String, ExpressRouteCrossConnectionPeering>();
        if (((ExpressRouteCrossConnectionInner)((Object)this.inner())).peerings() != null) {
            for (ExpressRouteCrossConnectionPeeringInner peering : ((ExpressRouteCrossConnectionInner)((Object)this.inner())).peerings()) {
                this.crossConnectionPeerings.put(peering.name(), new ExpressRouteCrossConnectionPeeringImpl(this, peering, peering.peeringType()));
            }
        }
    }

    protected Observable<ExpressRouteCrossConnectionInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCrossConnections().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<ExpressRouteCrossConnection> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<ExpressRouteCrossConnection, ExpressRouteCrossConnection>(){

            public ExpressRouteCrossConnection call(ExpressRouteCrossConnection expressRouteCrossConnection) {
                ExpressRouteCrossConnectionImpl impl = (ExpressRouteCrossConnectionImpl)expressRouteCrossConnection;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    @Override
    protected Observable<ExpressRouteCrossConnectionInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).expressRouteCrossConnections().updateTagsAsync(this.resourceGroupName(), this.name(), ((ExpressRouteCrossConnectionInner)((Object)this.inner())).getTags());
    }

    @Override
    public ExpressRouteCrossConnectionPeerings peerings() {
        if (this.peerings == null) {
            this.peerings = new ExpressRouteCrossConnectionPeeringsImpl(this);
        }
        return this.peerings;
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).secondaryAzurePort();
    }

    @Override
    public Integer sTag() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).sTag();
    }

    @Override
    public String peeringLocation() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).peeringLocation();
    }

    @Override
    public int bandwidthInMbps() {
        return Utils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionInner)((Object)this.inner())).bandwidthInMbps());
    }

    @Override
    public ExpressRouteCircuitReference expressRouteCircuit() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).expressRouteCircuit();
    }

    @Override
    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).serviceProviderProvisioningState();
    }

    @Override
    public String serviceProviderNotes() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).serviceProviderNotes();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ExpressRouteCrossConnectionInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public Map<String, ExpressRouteCrossConnectionPeering> peeringsMap() {
        return Collections.unmodifiableMap(this.crossConnectionPeerings);
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderProvisioningState(ServiceProviderProvisioningState state) {
        ((ExpressRouteCrossConnectionInner)((Object)this.inner())).withServiceProviderProvisioningState(state);
        return this;
    }

    @Override
    public ExpressRouteCrossConnection.Update withServiceProviderNotes(String notes) {
        ((ExpressRouteCrossConnectionInner)((Object)this.inner())).withServiceProviderNotes(notes);
        return this;
    }
}

