/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.FlowLogSettings;
import com.microsoft.azure.management.network.RetentionPolicyParameters;
import com.microsoft.azure.management.network.implementation.FlowLogInformationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class FlowLogSettingsImpl
extends RefreshableWrapperImpl<FlowLogInformationInner, FlowLogSettings>
implements FlowLogSettings,
FlowLogSettings.Update {
    private final NetworkWatcherImpl parent;
    private final String nsgId;

    FlowLogSettingsImpl(NetworkWatcherImpl parent, FlowLogInformationInner inner, String nsgId) {
        super((Object)inner);
        this.parent = parent;
        this.nsgId = nsgId;
    }

    public FlowLogSettings apply() {
        return (FlowLogSettings)this.applyAsync().toBlocking().last();
    }

    public Observable<FlowLogSettings> applyAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.parent().manager()).inner())).networkWatchers().setFlowLogConfigurationAsync(this.parent().resourceGroupName(), this.parent().name(), (FlowLogInformationInner)this.inner()).map((Func1)new Func1<FlowLogInformationInner, FlowLogSettings>(){

            public FlowLogSettings call(FlowLogInformationInner flowLogInformationInner) {
                return new FlowLogSettingsImpl(FlowLogSettingsImpl.this.parent, flowLogInformationInner, FlowLogSettingsImpl.this.nsgId);
            }
        });
    }

    public ServiceFuture<FlowLogSettings> applyAsync(ServiceCallback<FlowLogSettings> callback) {
        return ServiceFuture.fromBody(this.applyAsync(), callback);
    }

    @Override
    public FlowLogSettings.Update withLogging() {
        ((FlowLogInformationInner)this.inner()).withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withoutLogging() {
        ((FlowLogInformationInner)this.inner()).withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withStorageAccount(String storageId) {
        ((FlowLogInformationInner)this.inner()).withStorageId(storageId);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyEnabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.inner()).retentionPolicy().withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDisabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.inner()).retentionPolicy().withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDays(int days) {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.inner()).retentionPolicy().withDays(days);
        return this;
    }

    private void ensureRetentionPolicy() {
        if (((FlowLogInformationInner)this.inner()).retentionPolicy() == null) {
            ((FlowLogInformationInner)this.inner()).withRetentionPolicy(new RetentionPolicyParameters());
        }
    }

    public FlowLogSettings.Update update() {
        if (((FlowLogInformationInner)this.inner()).flowAnalyticsConfiguration() != null && ((FlowLogInformationInner)this.inner()).flowAnalyticsConfiguration().networkWatcherFlowAnalyticsConfiguration() == null) {
            ((FlowLogInformationInner)this.inner()).withFlowAnalyticsConfiguration(null);
        }
        return this;
    }

    protected Observable<FlowLogInformationInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.parent().manager()).inner())).networkWatchers().getFlowLogStatusAsync(this.parent().resourceGroupName(), this.parent().name(), ((FlowLogInformationInner)this.inner()).targetResourceId());
    }

    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    public String key() {
        return null;
    }

    @Override
    public String targetResourceId() {
        return ((FlowLogInformationInner)this.inner()).targetResourceId();
    }

    @Override
    public String storageId() {
        return ((FlowLogInformationInner)this.inner()).storageId();
    }

    @Override
    public boolean enabled() {
        return Utils.toPrimitiveBoolean((Boolean)((FlowLogInformationInner)this.inner()).enabled());
    }

    @Override
    public boolean isRetentionEnabled() {
        this.ensureRetentionPolicy();
        return Utils.toPrimitiveBoolean((Boolean)((FlowLogInformationInner)this.inner()).retentionPolicy().enabled());
    }

    @Override
    public int retentionDays() {
        this.ensureRetentionPolicy();
        return Utils.toPrimitiveInt((Integer)((FlowLogInformationInner)this.inner()).retentionPolicy().days());
    }

    @Override
    public String networkSecurityGroupId() {
        return this.nsgId;
    }
}

