/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualRouterPeerings.
 */
public class VirtualRouterPeeringsInner {
    /** The Retrofit service to perform REST calls. */
    private VirtualRouterPeeringsService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of VirtualRouterPeeringsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualRouterPeeringsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(VirtualRouterPeeringsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualRouterPeerings to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualRouterPeeringsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("peeringName") String peeringName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("peeringName") String peeringName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("peeringName") String peeringName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("peeringName") String peeringName, @Path("subscriptionId") String subscriptionId, @Body VirtualRouterPeeringInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("peeringName") String peeringName, @Path("subscriptionId") String subscriptionId, @Body VirtualRouterPeeringInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("virtualRouterName") String virtualRouterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualRouterName, String peeringName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().last().body();
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualRouterName, String peeringName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualRouterName, String peeringName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().single().body();
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, String peeringName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified peering from a Virtual Router.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Gets the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterPeeringInner object if successful.
     */
    public VirtualRouterPeeringInner get(String resourceGroupName, String virtualRouterName, String peeringName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().single().body();
    }

    /**
     * Gets the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterPeeringInner> getAsync(String resourceGroupName, String virtualRouterName, String peeringName, final ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    /**
     * Gets the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterPeeringInner object
     */
    public Observable<VirtualRouterPeeringInner> getAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map(new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>() {
            @Override
            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterPeeringInner object
     */
    public Observable<ServiceResponse<VirtualRouterPeeringInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.get(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterPeeringInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualRouterPeeringInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualRouterPeeringInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualRouterPeeringInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualRouterPeeringInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualRouterPeeringInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterPeeringInner object if successful.
     */
    public VirtualRouterPeeringInner createOrUpdate(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterPeeringInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters, final ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualRouterPeeringInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).map(new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>() {
            @Override
            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualRouterPeeringInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualRouterPeeringInner>() { }.getType());
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualRouterPeeringInner object if successful.
     */
    public VirtualRouterPeeringInner beginCreateOrUpdate(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualRouterPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters, final ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterPeeringInner object
     */
    public Observable<VirtualRouterPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).map(new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>() {
            @Override
            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the specified Virtual Router Peering.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param peeringName The name of the Virtual Router Peering.
     * @param parameters Parameters supplied to the create or update Virtual Router Peering operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualRouterPeeringInner object
     */
    public Observable<ServiceResponse<VirtualRouterPeeringInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterPeeringInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualRouterPeeringInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualRouterPeeringInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualRouterPeeringInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualRouterPeeringInner, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualRouterPeeringInner>() { }.getType())
                .register(201, new TypeToken<VirtualRouterPeeringInner>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterPeeringInner&gt; object if successful.
     */
    public PagedList<VirtualRouterPeeringInner> list(final String resourceGroupName, final String virtualRouterName) {
        ServiceResponse<Page<VirtualRouterPeeringInner>> response = listSinglePageAsync(resourceGroupName, virtualRouterName).toBlocking().single();
        return new PagedList<VirtualRouterPeeringInner>(response.body()) {
            @Override
            public Page<VirtualRouterPeeringInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterPeeringInner>> listAsync(final String resourceGroupName, final String virtualRouterName, final ListOperationCallback<VirtualRouterPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, virtualRouterName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterPeeringInner&gt; object
     */
    public Observable<Page<VirtualRouterPeeringInner>> listAsync(final String resourceGroupName, final String virtualRouterName) {
        return listWithServiceResponseAsync(resourceGroupName, virtualRouterName)
            .map(new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Page<VirtualRouterPeeringInner>>() {
                @Override
                public Page<VirtualRouterPeeringInner> call(ServiceResponse<Page<VirtualRouterPeeringInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterPeeringInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String virtualRouterName) {
        return listSinglePageAsync(resourceGroupName, virtualRouterName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(ServiceResponse<Page<VirtualRouterPeeringInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
    ServiceResponse<PageImpl<VirtualRouterPeeringInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<VirtualRouterPeeringInner>> * @param virtualRouterName The name of the Virtual Router.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterPeeringInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listSinglePageAsync(final String resourceGroupName, final String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(resourceGroupName, virtualRouterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterPeeringInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterPeeringInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterPeeringInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterPeeringInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterPeeringInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualRouterPeeringInner&gt; object if successful.
     */
    public PagedList<VirtualRouterPeeringInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualRouterPeeringInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterPeeringInner>(response.body()) {
            @Override
            public Page<VirtualRouterPeeringInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualRouterPeeringInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualRouterPeeringInner>> serviceFuture, final ListOperationCallback<VirtualRouterPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterPeeringInner&gt; object
     */
    public Observable<Page<VirtualRouterPeeringInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Page<VirtualRouterPeeringInner>>() {
                @Override
                public Page<VirtualRouterPeeringInner> call(ServiceResponse<Page<VirtualRouterPeeringInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualRouterPeeringInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(ServiceResponse<Page<VirtualRouterPeeringInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all Virtual Router Peerings in a Virtual Router resource.
     *
    ServiceResponse<PageImpl<VirtualRouterPeeringInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualRouterPeeringInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<VirtualRouterPeeringInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualRouterPeeringInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<VirtualRouterPeeringInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<VirtualRouterPeeringInner>, ErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<VirtualRouterPeeringInner>>() { }.getType())
                .registerError(ErrorException.class)
                .build(response);
    }

}
