/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.network.AuthenticationMethod;
import com.microsoft.azure.management.network.P2SVpnConnectionHealthRequest;
import com.microsoft.azure.management.network.P2SVpnConnectionRequest;
import com.microsoft.azure.management.network.P2SVpnProfileParameters;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;

/**
 * An instance of this class provides access to all the operations defined
 * in P2sVpnGateways.
 */
public class P2sVpnGatewaysInner implements InnerSupportsGet<P2SVpnGatewayInner>, InnerSupportsDelete<Void>, InnerSupportsListing<P2SVpnGatewayInner> {
    /** The Retrofit service to perform REST calls. */
    private P2sVpnGatewaysService service;
    /** The service client containing this operation class. */
    private NetworkManagementClientImpl client;

    /**
     * Initializes an instance of P2sVpnGatewaysInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public P2sVpnGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = retrofit.create(P2sVpnGatewaysService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for P2sVpnGateways to be
     * used by Retrofit to perform actually REST calls.
     */
    interface P2sVpnGatewaysService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Body P2SVpnGatewayInner p2SVpnGatewayParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Body P2SVpnGatewayInner p2SVpnGatewayParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways updateTags" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        Observable<Response<ResponseBody>> updateTags(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body TagsObject p2SVpnGatewayParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/p2svpnGateways")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways generateVpnProfile" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/generatevpnprofile")
        Observable<Response<ResponseBody>> generateVpnProfile(@Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body P2SVpnProfileParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginGenerateVpnProfile" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/generatevpnprofile")
        Observable<Response<ResponseBody>> beginGenerateVpnProfile(@Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body P2SVpnProfileParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways getP2sVpnConnectionHealth" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealth")
        Observable<Response<ResponseBody>> getP2sVpnConnectionHealth(@Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginGetP2sVpnConnectionHealth" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealth")
        Observable<Response<ResponseBody>> beginGetP2sVpnConnectionHealth(@Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways getP2sVpnConnectionHealthDetailed" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealthDetailed")
        Observable<Response<ResponseBody>> getP2sVpnConnectionHealthDetailed(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Body P2SVpnConnectionHealthRequest request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginGetP2sVpnConnectionHealthDetailed" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealthDetailed")
        Observable<Response<ResponseBody>> beginGetP2sVpnConnectionHealthDetailed(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("gatewayName") String gatewayName, @Body P2SVpnConnectionHealthRequest request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways disconnectP2sVpnConnections" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{p2sVpnGatewayName}/disconnectP2sVpnConnections")
        Observable<Response<ResponseBody>> disconnectP2sVpnConnections(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("p2sVpnGatewayName") String p2sVpnGatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body P2SVpnConnectionRequest request, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginDisconnectP2sVpnConnections" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{p2sVpnGatewayName}/disconnectP2sVpnConnections")
        Observable<Response<ResponseBody>> beginDisconnectP2sVpnConnections(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("p2sVpnGatewayName") String p2sVpnGatewayName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body P2SVpnConnectionRequest request, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Retrieves the details of a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner getByResourceGroup(String resourceGroupName, String gatewayName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single().body();
    }

    /**
     * Retrieves the details of a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Retrieves the details of a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<P2SVpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves the details of a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnGatewayInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnGatewayInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner createOrUpdate(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).toBlocking().last().body();
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters), serviceCallback);
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<P2SVpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (p2SVpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate(p2SVpnGatewayParameters);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, p2SVpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnGatewayInner>() { }.getType());
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner beginCreateOrUpdate(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).toBlocking().single().body();
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters), serviceCallback);
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<P2SVpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a virtual wan p2s vpn gateway if it doesn't exist else updates the existing gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param p2SVpnGatewayParameters Parameters supplied to create or Update a virtual wan p2s vpn gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (p2SVpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate(p2SVpnGatewayParameters);
        final String apiVersion = "2019-11-01";
        return service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, p2SVpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnGatewayInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnGatewayInner>() { }.getType())
                .register(201, new TypeToken<P2SVpnGatewayInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner updateTags(String resourceGroupName, String gatewayName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single().body();
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final Map<String, String> tags = null;
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(null);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnGatewayInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner updateTags(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).toBlocking().single().body();
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags), serviceCallback);
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates virtual wan p2s vpn gateway tags.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2019-11-01";
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(tags);
        return service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnGatewayInner> clientResponse = updateTagsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnGatewayInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnGatewayInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String gatewayName) {
        deleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last().body();
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String gatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String gatewayName) {
        return deleteWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String gatewayName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single().body();
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String gatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String gatewayName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a virtual wan p2s vpn gateway.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param gatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, gatewayName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object if successful.
     */
    public PagedList<P2SVpnGatewayInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<P2SVpnGatewayInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>(response.body()) {
            @Override
            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnGatewayInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<Page<P2SVpnGatewayInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>() {
                @Override
                public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
    ServiceResponse<PageImpl<P2SVpnGatewayInner>> * @param resourceGroupName The resource group name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnGatewayInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnGatewayInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object if successful.
     */
    public PagedList<P2SVpnGatewayInner> list() {
        ServiceResponse<Page<P2SVpnGatewayInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>(response.body()) {
            @Override
            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnGatewayInner>> listAsync(final ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<Page<P2SVpnGatewayInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>() {
                @Override
                public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnGatewayInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnGatewayInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner generateVpnProfile(String resourceGroupName, String gatewayName) {
        return generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last().body();
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName) {
        return generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> generateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final AuthenticationMethod authenticationMethod = null;
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(null);
        Observable<Response<ResponseBody>> observable = service.generateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>() { }.getType());
    }
    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner generateVpnProfile(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).toBlocking().last().body();
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod), serviceCallback);
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> generateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(authenticationMethod);
        Observable<Response<ResponseBody>> observable = service.generateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>() { }.getType());
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner beginGenerateVpnProfile(String resourceGroupName, String gatewayName) {
        return beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single().body();
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName) {
        return beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGenerateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final AuthenticationMethod authenticationMethod = null;
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(null);
        return service.beginGenerateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnProfileResponseInner> clientResponse = beginGenerateVpnProfileDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VpnProfileResponseInner object if successful.
     */
    public VpnProfileResponseInner beginGenerateVpnProfile(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).toBlocking().single().body();
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod, final ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod), serviceCallback);
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).map(new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>() {
            @Override
            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Generates VPN profile for P2S client of the P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param authenticationMethod VPN client authentication method. Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VpnProfileResponseInner object
     */
    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGenerateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(authenticationMethod);
        return service.beginGenerateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VpnProfileResponseInner> clientResponse = beginGenerateVpnProfileDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VpnProfileResponseInner> beginGenerateVpnProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VpnProfileResponseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VpnProfileResponseInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner getP2sVpnConnectionHealth(String resourceGroupName, String gatewayName) {
        return getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last().body();
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> getP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<P2SVpnGatewayInner> getP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName) {
        return getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> getP2sVpnConnectionHealthWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.getP2sVpnConnectionHealth(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<P2SVpnGatewayInner>() { }.getType());
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnGatewayInner object if successful.
     */
    public P2SVpnGatewayInner beginGetP2sVpnConnectionHealth(String resourceGroupName, String gatewayName) {
        return beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single().body();
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName, final ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName) {
        return beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).map(new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>() {
            @Override
            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the connection health of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnGatewayInner object
     */
    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginGetP2sVpnConnectionHealthWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        return service.beginGetP2sVpnConnectionHealth(resourceGroupName, gatewayName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnGatewayInner> clientResponse = beginGetP2sVpnConnectionHealthDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnGatewayInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnGatewayInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnConnectionHealthInner object if successful.
     */
    public P2SVpnConnectionHealthInner getP2sVpnConnectionHealthDetailed(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        return getP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request).toBlocking().last().body();
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnConnectionHealthInner> getP2sVpnConnectionHealthDetailedAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request, final ServiceCallback<P2SVpnConnectionHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(getP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request), serviceCallback);
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<P2SVpnConnectionHealthInner> getP2sVpnConnectionHealthDetailedAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        return getP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request).map(new Func1<ServiceResponse<P2SVpnConnectionHealthInner>, P2SVpnConnectionHealthInner>() {
            @Override
            public P2SVpnConnectionHealthInner call(ServiceResponse<P2SVpnConnectionHealthInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<P2SVpnConnectionHealthInner>> getP2sVpnConnectionHealthDetailedWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        Validator.validate(request);
        final String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = service.getP2sVpnConnectionHealthDetailed(this.client.subscriptionId(), resourceGroupName, gatewayName, request, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<P2SVpnConnectionHealthInner>() { }.getType());
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the P2SVpnConnectionHealthInner object if successful.
     */
    public P2SVpnConnectionHealthInner beginGetP2sVpnConnectionHealthDetailed(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        return beginGetP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request).toBlocking().single().body();
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<P2SVpnConnectionHealthInner> beginGetP2sVpnConnectionHealthDetailedAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request, final ServiceCallback<P2SVpnConnectionHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginGetP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request), serviceCallback);
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnConnectionHealthInner object
     */
    public Observable<P2SVpnConnectionHealthInner> beginGetP2sVpnConnectionHealthDetailedAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        return beginGetP2sVpnConnectionHealthDetailedWithServiceResponseAsync(resourceGroupName, gatewayName, request).map(new Func1<ServiceResponse<P2SVpnConnectionHealthInner>, P2SVpnConnectionHealthInner>() {
            @Override
            public P2SVpnConnectionHealthInner call(ServiceResponse<P2SVpnConnectionHealthInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the sas url to get the connection health detail of P2S clients of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param gatewayName The name of the P2SVpnGateway.
     * @param request Request parameters supplied to get p2s vpn connections detailed health.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the P2SVpnConnectionHealthInner object
     */
    public Observable<ServiceResponse<P2SVpnConnectionHealthInner>> beginGetP2sVpnConnectionHealthDetailedWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnConnectionHealthRequest request) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        Validator.validate(request);
        final String apiVersion = "2019-11-01";
        return service.beginGetP2sVpnConnectionHealthDetailed(this.client.subscriptionId(), resourceGroupName, gatewayName, request, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnConnectionHealthInner>>>() {
                @Override
                public Observable<ServiceResponse<P2SVpnConnectionHealthInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<P2SVpnConnectionHealthInner> clientResponse = beginGetP2sVpnConnectionHealthDetailedDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<P2SVpnConnectionHealthInner> beginGetP2sVpnConnectionHealthDetailedDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<P2SVpnConnectionHealthInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<P2SVpnConnectionHealthInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void disconnectP2sVpnConnections(String resourceGroupName, String p2sVpnGatewayName) {
        disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName).toBlocking().last().body();
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> disconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName), serviceCallback);
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> disconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName) {
        return disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> disconnectP2sVpnConnectionsWithServiceResponseAsync(String resourceGroupName, String p2sVpnGatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (p2sVpnGatewayName == null) {
            throw new IllegalArgumentException("Parameter p2sVpnGatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final String vpnConnectionIdsConverted = null;
        P2SVpnConnectionRequest request = new P2SVpnConnectionRequest();
        request.withVpnConnectionIds(null);
        Observable<Response<ResponseBody>> observable = service.disconnectP2sVpnConnections(this.client.subscriptionId(), resourceGroupName, p2sVpnGatewayName, apiVersion, this.client.acceptLanguage(), request, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>() { }.getType());
    }
    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void disconnectP2sVpnConnections(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds).toBlocking().last().body();
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> disconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds), serviceCallback);
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> disconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        return disconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> disconnectP2sVpnConnectionsWithServiceResponseAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (p2sVpnGatewayName == null) {
            throw new IllegalArgumentException("Parameter p2sVpnGatewayName is required and cannot be null.");
        }
        Validator.validate(vpnConnectionIds);
        final String apiVersion = "2019-11-01";
        P2SVpnConnectionRequest request = new P2SVpnConnectionRequest();
        request.withVpnConnectionIds(vpnConnectionIds);
        Observable<Response<ResponseBody>> observable = service.disconnectP2sVpnConnections(this.client.subscriptionId(), resourceGroupName, p2sVpnGatewayName, apiVersion, this.client.acceptLanguage(), request, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>() { }.getType());
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDisconnectP2sVpnConnections(String resourceGroupName, String p2sVpnGatewayName) {
        beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName).toBlocking().single().body();
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDisconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName), serviceCallback);
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDisconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName) {
        return beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(String resourceGroupName, String p2sVpnGatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (p2sVpnGatewayName == null) {
            throw new IllegalArgumentException("Parameter p2sVpnGatewayName is required and cannot be null.");
        }
        final String apiVersion = "2019-11-01";
        final List<String> vpnConnectionIds = null;
        P2SVpnConnectionRequest request = new P2SVpnConnectionRequest();
        request.withVpnConnectionIds(null);
        return service.beginDisconnectP2sVpnConnections(this.client.subscriptionId(), resourceGroupName, p2sVpnGatewayName, apiVersion, this.client.acceptLanguage(), request, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDisconnectP2sVpnConnectionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDisconnectP2sVpnConnections(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds).toBlocking().single().body();
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDisconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds), serviceCallback);
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDisconnectP2sVpnConnectionsAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        return beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(resourceGroupName, p2sVpnGatewayName, vpnConnectionIds).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Disconnect P2S vpn connections of the virtual wan P2SVpnGateway in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param p2sVpnGatewayName The name of the P2S Vpn Gateway.
     * @param vpnConnectionIds List of p2s vpn connection Ids.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDisconnectP2sVpnConnectionsWithServiceResponseAsync(String resourceGroupName, String p2sVpnGatewayName, List<String> vpnConnectionIds) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (p2sVpnGatewayName == null) {
            throw new IllegalArgumentException("Parameter p2sVpnGatewayName is required and cannot be null.");
        }
        Validator.validate(vpnConnectionIds);
        final String apiVersion = "2019-11-01";
        P2SVpnConnectionRequest request = new P2SVpnConnectionRequest();
        request.withVpnConnectionIds(vpnConnectionIds);
        return service.beginDisconnectP2sVpnConnections(this.client.subscriptionId(), resourceGroupName, p2sVpnGatewayName, apiVersion, this.client.acceptLanguage(), request, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDisconnectP2sVpnConnectionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDisconnectP2sVpnConnectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object if successful.
     */
    public PagedList<P2SVpnGatewayInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<P2SVpnGatewayInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>(response.body()) {
            @Override
            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnGatewayInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<P2SVpnGatewayInner>> serviceFuture, final ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<Page<P2SVpnGatewayInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>() {
                @Override
                public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a resource group.
     *
    ServiceResponse<PageImpl<P2SVpnGatewayInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnGatewayInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnGatewayInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object if successful.
     */
    public PagedList<P2SVpnGatewayInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<P2SVpnGatewayInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>(response.body()) {
            @Override
            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<P2SVpnGatewayInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<P2SVpnGatewayInner>> serviceFuture, final ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<Page<P2SVpnGatewayInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>() {
                @Override
                public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;P2SVpnGatewayInner&gt; object
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the P2SVpnGateways in a subscription.
     *
    ServiceResponse<PageImpl<P2SVpnGatewayInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;P2SVpnGatewayInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<P2SVpnGatewayInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<P2SVpnGatewayInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<P2SVpnGatewayInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
