/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.network.RetentionPolicyParameters;
import com.microsoft.azure.management.network.FlowLogFormatParameters;
import com.microsoft.azure.management.network.TrafficAnalyticsProperties;
import com.microsoft.azure.management.network.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * A flow log resource.
 */
@JsonFlatten
@SkipParentValidation
public class FlowLogInner extends Resource {
    /**
     * ID of network security group to which flow log will be applied.
     */
    @JsonProperty(value = "properties.targetResourceId", required = true)
    private String targetResourceId;

    /**
     * Guid of network security group to which flow log will be applied.
     */
    @JsonProperty(value = "properties.targetResourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String targetResourceGuid;

    /**
     * ID of the storage account which is used to store the flow log.
     */
    @JsonProperty(value = "properties.storageId", required = true)
    private String storageId;

    /**
     * Flag to enable/disable flow logging.
     */
    @JsonProperty(value = "properties.enabled")
    private Boolean enabled;

    /**
     * Parameters that define the retention policy for flow log.
     */
    @JsonProperty(value = "properties.retentionPolicy")
    private RetentionPolicyParameters retentionPolicy;

    /**
     * Parameters that define the flow log format.
     */
    @JsonProperty(value = "properties.format")
    private FlowLogFormatParameters format;

    /**
     * Parameters that define the configuration of traffic analytics.
     */
    @JsonProperty(value = "properties.flowAnalyticsConfiguration")
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;

    /**
     * The provisioning state of the flow log. Possible values include:
     * 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get iD of network security group to which flow log will be applied.
     *
     * @return the targetResourceId value
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set iD of network security group to which flow log will be applied.
     *
     * @param targetResourceId the targetResourceId value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get guid of network security group to which flow log will be applied.
     *
     * @return the targetResourceGuid value
     */
    public String targetResourceGuid() {
        return this.targetResourceGuid;
    }

    /**
     * Get iD of the storage account which is used to store the flow log.
     *
     * @return the storageId value
     */
    public String storageId() {
        return this.storageId;
    }

    /**
     * Set iD of the storage account which is used to store the flow log.
     *
     * @param storageId the storageId value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    /**
     * Get flag to enable/disable flow logging.
     *
     * @return the enabled value
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set flag to enable/disable flow logging.
     *
     * @param enabled the enabled value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get parameters that define the retention policy for flow log.
     *
     * @return the retentionPolicy value
     */
    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set parameters that define the retention policy for flow log.
     *
     * @param retentionPolicy the retentionPolicy value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    /**
     * Get parameters that define the flow log format.
     *
     * @return the format value
     */
    public FlowLogFormatParameters format() {
        return this.format;
    }

    /**
     * Set parameters that define the flow log format.
     *
     * @param format the format value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    /**
     * Get parameters that define the configuration of traffic analytics.
     *
     * @return the flowAnalyticsConfiguration value
     */
    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    /**
     * Set parameters that define the configuration of traffic analytics.
     *
     * @param flowAnalyticsConfiguration the flowAnalyticsConfiguration value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    /**
     * Get the provisioning state of the flow log. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get resource ID.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set resource ID.
     *
     * @param id the id value to set
     * @return the FlowLogInner object itself.
     */
    public FlowLogInner withId(String id) {
        this.id = id;
        return this;
    }

}
