/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnGatewayInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnGatewaysInner
implements InnerSupportsGet<VpnGatewayInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VpnGatewayInner> {
    private VpnGatewaysService service;
    private NetworkManagementClientImpl client;

    public VpnGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnGatewaysService)retrofit.create(VpnGatewaysService.class);
        this.client = client;
    }

    public VpnGatewayInner getByResourceGroup(String resourceGroupName, String gatewayName) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnGatewayInner>>>(){

            public Observable<ServiceResponse<VpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnGatewayInner createOrUpdate(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters), serviceCallback);
    }

    public Observable<VpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (vpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter vpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnGatewayParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", vpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnGatewayInner>(){}.getType());
    }

    public VpnGatewayInner beginCreateOrUpdate(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters), serviceCallback);
    }

    public Observable<VpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, vpnGatewayParameters).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, VpnGatewayInner vpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (vpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter vpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnGatewayParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", vpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnGatewayInner>>>(){

            public Observable<ServiceResponse<VpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnGatewayInner>(){}.getType()).register(201, new TypeToken<VpnGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnGatewayInner updateTags(String resourceGroupName, String gatewayName) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject vpnGatewayParameters = new TagsObject();
        vpnGatewayParameters.withTags(null);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", this.client.acceptLanguage(), vpnGatewayParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnGatewayInner>>>(){

            public Observable<ServiceResponse<VpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VpnGatewayInner updateTags(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags), serviceCallback);
    }

    public Observable<VpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject vpnGatewayParameters = new TagsObject();
        vpnGatewayParameters.withTags(tags);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", this.client.acceptLanguage(), vpnGatewayParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnGatewayInner>>>(){

            public Observable<ServiceResponse<VpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnGatewayInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String gatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String gatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String gatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String gatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String gatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String gatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnGatewayInner reset(String resourceGroupName, String gatewayName) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.resetWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<VpnGatewayInner> resetAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnGatewayInner> resetAsync(String resourceGroupName, String gatewayName) {
        return this.resetWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> resetWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.reset(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnGatewayInner>(){}.getType());
    }

    public VpnGatewayInner beginReset(String resourceGroupName, String gatewayName) {
        return (VpnGatewayInner)((Object)((ServiceResponse)this.beginResetWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnGatewayInner> beginResetAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResetWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnGatewayInner> beginResetAsync(String resourceGroupName, String gatewayName) {
        return this.beginResetWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnGatewayInner>, VpnGatewayInner>(){

            public VpnGatewayInner call(ServiceResponse<VpnGatewayInner> response) {
                return (VpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnGatewayInner>> beginResetWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginReset(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnGatewayInner>>>(){

            public Observable<ServiceResponse<VpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnGatewaysInner.this.beginResetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnGatewayInner> beginResetDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnGatewayInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnGatewayInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VpnGatewayInner>((Page)response.body()){

            public Page<VpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(String nextPageLink) {
                return VpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Page<VpnGatewayInner>>(){

            public Page<VpnGatewayInner> call(ServiceResponse<Page<VpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(ServiceResponse<Page<VpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnGatewayInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VpnGatewayInner>((Page)response.body()){

            public Page<VpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnGatewayInner>> listAsync(ListOperationCallback<VpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(String nextPageLink) {
                return VpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnGatewayInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Page<VpnGatewayInner>>(){

            public Page<VpnGatewayInner> call(ServiceResponse<Page<VpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(ServiceResponse<Page<VpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnGatewayInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnGatewayInner>((Page)response.body()){

            public Page<VpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnGatewayInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VpnGatewayInner>> serviceFuture, ListOperationCallback<VpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(String nextPageLink) {
                return VpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnGatewayInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Page<VpnGatewayInner>>(){

            public Page<VpnGatewayInner> call(ServiceResponse<Page<VpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(ServiceResponse<Page<VpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnGatewaysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnGatewayInner>((Page)response.body()){

            public Page<VpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnGatewayInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VpnGatewayInner>> serviceFuture, ListOperationCallback<VpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(String nextPageLink) {
                return VpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Page<VpnGatewayInner>>(){

            public Page<VpnGatewayInner> call(ServiceResponse<Page<VpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnGatewayInner>>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(ServiceResponse<Page<VpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VpnGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Body VpnGatewayInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Body VpnGatewayInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways reset"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/reset")
        public Observable<Response<ResponseBody>> reset(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways beginReset"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/reset")
        public Observable<Response<ResponseBody>> beginReset(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/vpnGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnGateways listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

