/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualHubRouteTableV2Inner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualHubRouteTableV2sInner {
    private VirtualHubRouteTableV2sService service;
    private NetworkManagementClientImpl client;

    public VirtualHubRouteTableV2sInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualHubRouteTableV2sService)retrofit.create(VirtualHubRouteTableV2sService.class);
        this.client = client;
    }

    public VirtualHubRouteTableV2Inner get(String resourceGroupName, String virtualHubName, String routeTableName) {
        return (VirtualHubRouteTableV2Inner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubRouteTableV2Inner> getAsync(String resourceGroupName, String virtualHubName, String routeTableName, ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    public Observable<VirtualHubRouteTableV2Inner> getAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map((Func1)new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>(){

            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return (VirtualHubRouteTableV2Inner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> getWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubRouteTableV2Inner>>>(){

            public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubRouteTableV2sInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualHubRouteTableV2Inner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualHubRouteTableV2Inner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualHubRouteTableV2Inner createOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return (VirtualHubRouteTableV2Inner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters), serviceCallback);
    }

    public Observable<VirtualHubRouteTableV2Inner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).map((Func1)new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>(){

            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return (VirtualHubRouteTableV2Inner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (virtualHubRouteTableV2Parameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)virtualHubRouteTableV2Parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2019-11-01", virtualHubRouteTableV2Parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualHubRouteTableV2Inner>(){}.getType());
    }

    public VirtualHubRouteTableV2Inner beginCreateOrUpdate(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return (VirtualHubRouteTableV2Inner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters, ServiceCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters), serviceCallback);
    }

    public Observable<VirtualHubRouteTableV2Inner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName, virtualHubRouteTableV2Parameters).map((Func1)new Func1<ServiceResponse<VirtualHubRouteTableV2Inner>, VirtualHubRouteTableV2Inner>(){

            public VirtualHubRouteTableV2Inner call(ServiceResponse<VirtualHubRouteTableV2Inner> response) {
                return (VirtualHubRouteTableV2Inner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName, VirtualHubRouteTableV2Inner virtualHubRouteTableV2Parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        if (virtualHubRouteTableV2Parameters == null) {
            throw new IllegalArgumentException("Parameter virtualHubRouteTableV2Parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)virtualHubRouteTableV2Parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2019-11-01", virtualHubRouteTableV2Parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualHubRouteTableV2Inner>>>(){

            public Observable<ServiceResponse<VirtualHubRouteTableV2Inner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubRouteTableV2sInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualHubRouteTableV2Inner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualHubRouteTableV2Inner>(){}.getType()).register(201, new TypeToken<VirtualHubRouteTableV2Inner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualHubName, String routeTableName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualHubName, String routeTableName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualHubName, routeTableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualHubName, String routeTableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        if (routeTableName == null) {
            throw new IllegalArgumentException("Parameter routeTableName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualHubName, routeTableName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualHubRouteTableV2sInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualHubRouteTableV2Inner> list(String resourceGroupName, String virtualHubName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, virtualHubName).toBlocking().single();
        return new PagedList<VirtualHubRouteTableV2Inner>((Page)response.body()){

            public Page<VirtualHubRouteTableV2Inner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubRouteTableV2sInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubRouteTableV2Inner>> listAsync(String resourceGroupName, String virtualHubName, ListOperationCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, virtualHubName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(String nextPageLink) {
                return VirtualHubRouteTableV2sInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubRouteTableV2Inner>> listAsync(String resourceGroupName, String virtualHubName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualHubName).map((Func1)new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Page<VirtualHubRouteTableV2Inner>>(){

            public Page<VirtualHubRouteTableV2Inner> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listWithServiceResponseAsync(String resourceGroupName, String virtualHubName) {
        return this.listSinglePageAsync(resourceGroupName, virtualHubName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubRouteTableV2sInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualHubName == null) {
            throw new IllegalArgumentException("Parameter virtualHubName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, virtualHubName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubRouteTableV2sInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubRouteTableV2Inner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualHubRouteTableV2Inner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualHubRouteTableV2Inner>((Page)response.body()){

            public Page<VirtualHubRouteTableV2Inner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualHubRouteTableV2sInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualHubRouteTableV2Inner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualHubRouteTableV2Inner>> serviceFuture, ListOperationCallback<VirtualHubRouteTableV2Inner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(String nextPageLink) {
                return VirtualHubRouteTableV2sInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualHubRouteTableV2Inner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Page<VirtualHubRouteTableV2Inner>>(){

            public Page<VirtualHubRouteTableV2Inner> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(ServiceResponse<Page<VirtualHubRouteTableV2Inner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualHubRouteTableV2sInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>>>(){

            public Observable<ServiceResponse<Page<VirtualHubRouteTableV2Inner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualHubRouteTableV2sInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualHubRouteTableV2Inner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualHubRouteTableV2Inner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualHubRouteTableV2sService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="routeTableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="routeTableName") String var4, @Query(value="api-version") String var5, @Body VirtualHubRouteTableV2Inner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="routeTableName") String var4, @Query(value="api-version") String var5, @Body VirtualHubRouteTableV2Inner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="routeTableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Path(value="routeTableName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualHubName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualHubRouteTableV2s listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

